/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.shutter.simulator;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.shutter.ShutterModule;
import org.lsst.ccs.subsystems.shutter.common.MotorHistory;
import org.lsst.ccs.subsystems.shutter.common.MotorStatus;
import org.lsst.ccs.subsystems.shutter.status.DriverStatus;

public class ShutterSimulator extends Module  {

//    private final ShutterAssembly assembly;
    private boolean exposureActive = false;
    private List<MotorHistory> histories = new ArrayList<MotorHistory>();
    private EventListenerList listeners = new EventListenerList();
    private boolean firstShutterInOpenPosition = true;

//    ShutterSimulator(ShutterAssembly assembly) {
    public ShutterSimulator() {
//        this.assembly = assembly;
        histories.add(new MotorHistory());
        histories.add(new MotorHistory());
    }





    public List<MotorHistory> getHistories() {
        return histories;
    }

    public boolean isExposureActive() {
        return exposureActive;
    }

//    public void addChangeListener(ChangeListener l) {
//        listeners.add(ChangeListener.class, l);
//    }
//
//    public void removeChangeListener(ChangeListener l) {
//        listeners.remove(ChangeListener.class, l);
//    }
//
//    private void fireChangeListeners() {
//        ChangeEvent e = new ChangeEvent(this);
//        for (ChangeListener l : listeners.getListeners(ChangeListener.class)) {
//            l.stateChanged(e);
//        }
//    }

    boolean getIsFirstShutterInOpenPosition() {
        return firstShutterInOpenPosition;
    }

    void setIsFirstShutterInOpenPosition(boolean isOpen) {
        firstShutterInOpenPosition = isOpen;
    }

    public void takeImage(final double exposureTimeSeconds, final double openTimeSeconds) {
        sendToStatus(new DriverStatus(exposureTimeSeconds,openTimeSeconds,firstShutterInOpenPosition));
        final long start = System.currentTimeMillis();
        int openTime = (int) (1000 * openTimeSeconds);
        int exposureTime = (int) (1000 * exposureTimeSeconds);

        for (MotorHistory history : histories) {
            history.reset();
        }

        
        final MotorController motor1 = new MotorController(this,openTime,"motor1");
//        motor1.addChangeListener(new ChangeListener() {
//
//            @Override
//            public void stateChanged(ChangeEvent e) {
//                assembly.getShutter(0).setShutterPosition((float) motor1.getPosition());
//                assembly.repaint();
//            }
//        });

        final MotorController motor2 = new MotorController(this,openTime,"motor2");
//        motor2.addChangeListener(new ChangeListener() {
//
//            @Override
//            public void stateChanged(ChangeEvent e) {
//                assembly.getShutter(1).setShutterPosition((float) motor2.getPosition());
//                assembly.repaint();
//            }
//        });
        // Which motor runs first, and in which direction
//        boolean firstShutterInitiallyOpen = assembly.getShutter(0).getShutterPosition() < .5;
        boolean firstShutterInitiallyOpen = getIsFirstShutterInOpenPosition();
        final MotorController firstMotor = firstShutterInitiallyOpen ? motor2 : motor1;
        final MotorController secondMotor = firstShutterInitiallyOpen ? motor1 : motor2;
        firstMotor.setRunInReverse(true);
        setIsFirstShutterInOpenPosition(!firstShutterInitiallyOpen);

        exposureActive = true;
//        fireChangeListeners();
        Timer timer1 = new Timer(exposureTime, new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                secondMotor.start();
            }

        });
        timer1.setRepeats(false);
        Timer timer2 = new Timer(exposureTime + openTime, new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                exposureActive = false;
//                fireChangeListeners();
            }
        });
        timer2.setRepeats(false);
        Timer timer3 = new Timer(10, new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                double t = (System.currentTimeMillis() - start) / 1000.;
                histories.get(0).addData(t, motor1.getAcceleration(), motor1.getVelocity(), motor1.getPosition());
                histories.get(1).addData(t, motor2.getAcceleration(), motor2.getVelocity(), motor2.getPosition());
                if (t > openTimeSeconds + exposureTimeSeconds) {
                    ((Timer) e.getSource()).stop();
                }
            }
        });
        timer1.start();
        timer2.start();
        timer3.start();
        firstMotor.start();

        while ( timer1.isRunning() || timer2.isRunning() || timer3.isRunning() ) {
            
        }

    }




    public void postMovementToStatusBus(String motorName) {
        int index = 0;
        if ( motorName.contains("2") )
            index = 1;

        sendToStatus(new MotorStatus("motor"+index,histories.get(index)) );
    }

    private static class MotorController {

        private long openTime;
        private long start;
        private long end;
        private Timer timer;
        private double xPrev;
        private double velocity;
        private double position;
        private double acceleration;
        private boolean reverse;
        private EventListenerList listeners = new EventListenerList();
        private String motorName;
        private ShutterSimulator simulator;

        MotorController(ShutterSimulator simulator, long openTime, String motorName) {
            this.openTime = openTime;
            this.motorName = motorName;
            this.simulator = simulator;
        }

        private void setRunInReverse(boolean reverse) {
            this.reverse = reverse;
            position = reverse ? 1 : 0;
        }

        void start() {
            start = System.currentTimeMillis();
            end = start + openTime;

            timer = new Timer(10, new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent e) {
                    long now = System.currentTimeMillis();
                    if (now > end) {
                        position = reverse ? 0 : 1;
                        velocity = 0;
                        acceleration = 0;
                        timer.stop();
                        simulator.postMovementToStatusBus(motorName);
                    } else {
                        double x = (double) (now - start) / openTime;
                        acceleration = calculateAcceleration(x);
                        double delta = x - xPrev;
                        xPrev = x;
                        velocity += 4 * acceleration * delta;
                        position += (reverse ? -1 : 1) * 2 * velocity * delta;
                        //System.out.printf("%g %g %g %g\n", x, acceleration, velocity, position);
                    }
//                    fireChangeListeners();
                }
            });
            timer.start();
        }

//        public void addChangeListener(ChangeListener l) {
//            listeners.add(ChangeListener.class, l);
//        }
//
//        public void removeChangeListener(ChangeListener l) {
//            listeners.remove(ChangeListener.class, l);
//        }
//
//        private void fireChangeListeners() {
//            ChangeEvent e = new ChangeEvent(this);
//            for (ChangeListener l : listeners.getListeners(ChangeListener.class)) {
//                l.stateChanged(e);
//            }
//        }

        /**
         * Calculate acceleration assuming a sawtooth acceleration profile
         * @param phase Phase [0,1]
         * @return Acceleration [-1,1]
         */
        private static double calculateAcceleration(double phase) {
            if (phase < .25) {
                return phase * 4;
            } else if (phase < .75) {
                return 1 - (phase - .25) * 4;
            } else {
                return phase * 4 - 4;
            }
        }

        public double getAcceleration() {
            return acceleration;
        }

        public double getPosition() {
            return position;
        }

        public double getVelocity() {
            return velocity;
        }
    }




}
