package org.lsst.ccs.subsystems.shutter.simulator;

import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorSimulator;
import org.lsst.ccs.subsystems.shutter.common.BladePositionImpl;
import org.lsst.ccs.subsystems.shutter.interfaces.BladePosition;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lsst.ccs.subsystems.shutter.interfaces.EncoderSimulatorListener;

/**
 *
 * @author azemoon
 */
public class MotorEncoderSimulator {

    //private List<MotorPosition> history = new ArrayList<MotorPosition>();
    private List<BladePosition> history = new ArrayList<BladePosition>();
    //private List<BladePositionImpl> history = new ArrayList<BladePositionImpl>();
    private List<EncoderSimulatorListener> listeners = new ArrayList<EncoderSimulatorListener>();
    private final MotorSimulator simulator;
    private long nextPublishTime = 0;
    private static long SAMPLINGINTERVAL = 100;
    private boolean stopped = false;

    public MotorEncoderSimulator(MotorSimulator simulator) {
        System.out.println("MotorEncoderSimulator STARTED ************** ");
        this.simulator = simulator;
        simulator.addMotorListener(new MotorListener() {
            
            final Random random = new Random();

            @Override
            public void positionChanged(MotorPosition p) {
                if ( stopped) {
                    history.clear();
                    stopped = false;
                }
                
                if (p.getTime() > nextPublishTime) {
                    System.out.println("&&&&&&&& MotorEncoderSimulator: Time " + p.getTime() + " position " + p.getPosition() );
                    smearAndAdd(p, random);
                    nextPublishTime = p.getTime() + SAMPLINGINTERVAL;
                }
            }

            @Override
            public void motorStopped() {
                fireEncoderSimulatorReadyEvent();
                stopped = true;
                nextPublishTime = 0;
            }
        });
    }

    private void smearAndAdd(MotorPosition p, Random random) {
        double delta = random.nextGaussian() * 0.02;
        //System.out.println("MotorPositionCollector: position " + p.getPosition() + " delta " + delta );
        double position = (double) p.getPosition() + delta;
        //System.out.println("MotorPositionCollector: Time " + p.getTime() + " position " + position );
        //FIXME: Modifying the position in the existing motor position object, which may be passed
        //to multiple listeners seems very dubious
        BladePositionImpl bladePosition = new BladePositionImpl();
        bladePosition.setRelPosition((float) position);
        bladePosition.setTime(p.getTime());
        history.add(bladePosition);
    }

    public MotorSimulator getMotorSimulator() {
        return this.simulator;
    }

    public void addEncoderSimulatorListener(EncoderSimulatorListener l) {
        listeners.add(l);
    }

    public void removeEncoderSimulatorListener(EncoderSimulatorListener l) {
        listeners.remove(l);
    }

    private void fireEncoderSimulatorReadyEvent() {
        for (EncoderSimulatorListener l : new ArrayList<EncoderSimulatorListener>(listeners)) {
            l.encoderSimulatorReady(history);
        }
    }
}
