
package org.lsst.ccs.subsystems.shutter.simulator;

import org.lsst.ccs.subsystems.shutter.interfaces.EncoderSimulatorListener;
import org.lsst.ccs.subsystems.shutter.simulator.MotorEncoderSimulator;
import org.lsst.ccs.subsystems.shutter.simulator.HallSensorSimulator;
import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistoryListener;
import org.lsst.ccs.subsystems.shutter.interfaces.BladeSet;
import org.lsst.ccs.subsystems.shutter.interfaces.HallSensorListener;
import org.lsst.ccs.subsystems.shutter.common.MovementHistoryImpl;
import org.lsst.ccs.subsystems.shutter.interfaces.BladeSetConfiguration;
import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistory;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorSimulator;
import org.lsst.ccs.subsystems.shutter.interfaces.BladePosition;
import org.lsst.ccs.subsystems.shutter.interfaces.HallTransition;

//import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistoryListener;

import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import java.util.List;
import java.util.ArrayList;

/**
 *
 * @author azemoon
 */
public class BladeSetSimulator implements BladeSet {

    private List<MovementHistoryListener> mvhListeners = new ArrayList<MovementHistoryListener>();
    private EventListenerList listeners = new EventListenerList();
    private MotorSimulator motorSimulator;
    private MotorEncoderSimulator encoderSimulator;
    private HallSensorSimulator hallSensorSimulator;
    private MovementHistoryImpl movementHistory;
    private int index;
    private boolean hallSensorDataRecorded = false;
    private boolean encoderDataRecorded = false;

    public BladeSetSimulator() {
        motorSimulator = new MotorSimulator();
        //encoderSimulator = new MotorEncoderSimulator(motorSimulator);
        //hallSensorSimulator = new HallSensorSimulator(motorSimulator);
    }

    @Override
    public BladeSetConfiguration getBladeSetConfiguration() {
        throw new UnsupportedOperationException("Not supported yet.");
    }


    @Override
    public float getCurrentPosition() {
        return (float) motorSimulator.getInitialMotorPosition();
    }



    @Override
    public void setIndex(int index) {
        System.out.println("********* BladeSetSimulator: setting index to " + index );
        this.index = index;
        if ( index == 0 ){
            motorSimulator.setInitialMotorPosition(0);
        } else {
            motorSimulator.setInitialMotorPosition(1);
        }
        encoderSimulator = new MotorEncoderSimulator(motorSimulator);
        hallSensorSimulator = new HallSensorSimulator(motorSimulator);
    }

    @Override
    public int getIndex() {
        return index;
    }

    //@Override
    public MovementHistory getMovementHistory() {
        return movementHistory;
    }

    public void start() {
    }
    public double getBladeSetPosition() {
        return motorSimulator.getInitialMotorPosition();
    }

    public void addChangeListener(ChangeListener l) {
        listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        listeners.remove(ChangeListener.class, l);
    }


    public void addEncoderSimulatorListener(EncoderSimulatorListener l) {
        encoderSimulator.addEncoderSimulatorListener(l);
    }

    public void removeEncoderSimulatorListener(EncoderSimulatorListener l) {
        encoderSimulator.removeEncoderSimulatorListener(l);
    }

    public void addHallSensorListener(HallSensorListener l) {
        hallSensorSimulator.addHallSensorListener(l);
    }

    public void removeHallSensorListener(HallSensorListener l) {
        hallSensorSimulator.removeHallSensorListener(l);
    }

    @Override
    public void addMovementHistoryListener(MovementHistoryListener l) {
        mvhListeners.add(l);
    }

    @Override
    public void removeMovementHistoryListener(MovementHistoryListener l) {
        mvhListeners.remove(l);
    }

    private void fireMovementHistoryFinalized(MovementHistory h) {
        //TODO: This will fail if anyone adds or removes a listener
        //while this method is executing.
        System.out.println("********* BladeSetSimulator: firing fireMovementHistoryFinalized ******* ");
        for (MovementHistoryListener l : new ArrayList<MovementHistoryListener>(mvhListeners)) {
            l.movementHistoryFinalized(h);
        }
    }

    private void fireMovementHistoryUpdated(MovementHistory h) {
        //TODO: This will fail if anyone adds or removes a listener
        //while this method is executing.
        System.out.println("********* BladeSetSimulator: firing fireMovementHistoryUpdated ******* ");
        for (MovementHistoryListener l : new ArrayList<MovementHistoryListener>(mvhListeners)) {
            l.movementHistoryUpdated(h);
        }
    }

    @Override
    public void moveToPosition( float targetPosition, float moveTimeSeconds) {
        movementHistory = new MovementHistoryImpl(index, getCurrentPosition());

        encoderSimulator.addEncoderSimulatorListener(new EncoderSimulatorListener() {

            @Override
            public void encoderSimulatorReady(List<BladePosition> h) {
                movementHistory.setMovementProfile(h);
                movementHistory.setStatus(1);
                movementHistory.setStartTime(h.get(0).getTime());
                movementHistory.setEndPosition(h.get(h.size() - 1).getPosition());
                movementHistory.setEndTime(h.get(h.size() - 1).getTime());
                encoderSimulator.removeEncoderSimulatorListener(this);
                System.out.println("********* BladeSetSimulator: encoderSimulatorReady " + h.size() + " ******* ");
                
                if (hallSensorDataRecorded) {                    
                    fireMovementHistoryFinalized(movementHistory);
                    hallSensorDataRecorded = false;
                } else {
                    encoderDataRecorded = true;
                }
            }
        });

        hallSensorSimulator.addHallSensorListener(new HallSensorListener() {
            @Override
            public void hallSensorDataReady(List<HallTransition> h) {
                movementHistory.setHallTransitions(h);
                hallSensorSimulator.removeHallSensorListener(this);
                System.out.println("********* BladeSetSimulator: hallSensorDataReady " + h.size() + " ******* ");
                
                if (encoderDataRecorded) {                    
                    fireMovementHistoryFinalized(movementHistory);
                    encoderDataRecorded = false;
                } else {
                    hallSensorDataRecorded = true;
                }
            }

            @Override
            public void hallSensorTransition(HallTransition ht ) {
                movementHistory.addHallTransition(ht);
                fireMovementHistoryUpdated(movementHistory);
            }
        });

        motorSimulator.simulateMovement(targetPosition, (double) moveTimeSeconds);
    }
}

