package org.lsst.ccs.subsystems.shutter.interfaces;

public interface HallTransition {


    /**
     * Get the Epoch microseconds when the transition occurred.
     *
     */
    public long getTransitionTime();


    /**
     * Get the id of the Hall Sensor
     */
    public int getSensorId();


    /**
     * Check if the sensor is open after the transition.
     *
     * Open is the state when no actuating magnet is near the sensor.
     * The sensor closes and re-opens as a magnet moves past it.
     *
     */
    public boolean isOpen();


    /**
     * Check if the motion was in the reverse direction, in shutter coordinates.
     *
     */
    public boolean isReverse();


    /**
     * Get the position (in mm) where the transition occurred
     *
     */
    public float getPosition();


    /**
     * Get the relative position (0 - 1) where the transition occurred
     *
     */
    public float getRelPosition();

}
