package org.lsst.ccs.subsystems.shutter.interfaces;

public interface BladePosition {

    /**
     * Get the position of the leading blade.
     *
     * This is the distance, in mm, from the fixed shutter origin.
     * One blade is opening in the positive direction, the other one in the
     *  negative direction
     *
     */
    public float getPosition();


    /**
     * Get the relative position of the leading blade.
     *
     * This is a number in the range (0,1) representing the fraction that
     * the blade is closed.
     *
     */
    public float getRelPosition();


    /**
     * Get the Epoch microseconds when the leading blade was at the position.
     *
     */
    public long getTime();

}
