package org.lsst.ccs.subsystems.shutter.gui.jas;

import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.plugin.jas3.LsstSubsystemPlugin;
import org.lsst.ccs.subsystems.shutter.gui.ShutterControlPanel;
import org.lsst.ccs.subsystems.shutter.gui.ShutterGUISubsystem;
import org.lsst.ccs.subsystems.shutter.gui.ShutterUI;
import org.lsst.ccs.subsystems.shutter.gui.StandaloneShutterDemo;
import org.lsst.ccs.subsystems.shutter.simulator.motor.ShutterSimulator;

/**
 *
 */
public class ShutterJasPlugin extends LsstSubsystemPlugin {

    private ShutterGUISubsystem shutterGuiSubsystem;
    FreeHEPLookup lookup;

    @Override
    protected void postInit() {
        super.postInit();

        shutterGuiSubsystem = new ShutterGUISubsystem();
        this.getApplication().getPageManager().openPage(shutterGuiSubsystem.getDisplayComponent(), "Shutter GUI", null);
        this.getApplication().getConsoleManager().openPage(shutterGuiSubsystem.getControlsComponent(), "Shutter Control", null);

        Studio studio = (Studio) Studio.getApplication();
        lookup = studio.getLookup();
        lookup.add(this);
    }

    @Override
    public void connectToMessagingFactory() {
        shutterGuiSubsystem.initGui();
    }

    @Override
    public void disconnectFromMessagingFactory() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeRestServices() {
    }

    @Override
    public void resetRestServices() {
    }
    
    
}
