package org.lsst.ccs.subsystems.shutter.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.subsystems.shutter.common.HallTransitionImpl;
import org.lsst.ccs.subsystems.shutter.simulator.motor.HallSensorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;
import org.lsst.ccs.subsystems.shutter.simulator.motor.EncoderSimulatorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.ShutterSimulator;
import javax.swing.Timer;

/**
 *
 * @author azemoon
 */
public class StandaloneShutterDemo {
    
    public static void main(String[] args) {
        StandaloneShutterDemo demo = new StandaloneShutterDemo();
        demo.start ();
    }

    public void start() {
        final ShutterUI ui = new ShutterUI();
        final ShutterControlPanel control = new ShutterControlPanel();
        final ShutterSimulator shutterSimulator = new ShutterSimulator();

        shortCircuitMMS(control, shutterSimulator, ui);

        shutterSimulator.start();

        JFrame frame = new JFrame("Shutter GUI demo");
        frame.getRootPane().setDoubleBuffered(true);
        frame.getContentPane().add(ui,BorderLayout.CENTER);
        frame.getContentPane().add(control,BorderLayout.SOUTH);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setResizable(true);
        frame.pack();
        frame.setVisible(true);

    }

    /**
     * This communication should really go via MMS, but for this demo we hardwire
     * the different components directly together.
     * @param control
     * @param shutterSimulator
     * @param ui 
     */
    public static void shortCircuitMMS(final ShutterControlPanel control, final ShutterSimulator shutterSimulator, final ShutterUI ui) {
        control.addTakeImageActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {

               shutterSimulator.takeImage(control.getMovementTime(), control.getExposureTime());
               ui.takeImage(control.getMovementTime(), control.getExposureTime());
    /*
                if ( docked ){
                    Timer timer = new Timer(4000, new ActionListener() {

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            shutterSimulator.takeImage(control.getMovementTime(), control.getExposureTime());
                            ui.takeImage(control.getMovementTime(), control.getExposureTime());
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
     *
     */
            }
        });
        
        control.addMoveToActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {

                shutterSimulator.moveToPosition(control.getBladeSetIndex(), control.getTargetPosition(), control.getMovementTime(), true);
                ui.moveToPosition(control.getBladeSetIndex(), control.getTargetPosition(), control.getMovementTime());
            }
        });

        control.addCloseShutterActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {

                shutterSimulator.closeShutter();
                ui.closeShutter();
            }
        });


        ui.addChangeListener(new ChangeListener() {

            @Override
            public void stateChanged(ChangeEvent e) {
                //TODO: make sure ShutterSimulator is finished as well.
                control.setEnabled(!ui.isInMotion());
            }
        });

        createPositionCollector(0, shutterSimulator, ui);
        createPositionCollector(1, shutterSimulator, ui);

        createHallSensorListener(0, shutterSimulator, ui);
        createHallSensorListener(1, shutterSimulator, ui);
    }

    private static void createHallSensorListener(final int index, final ShutterSimulator shutterSimulator, final ShutterUI ui) {
        shutterSimulator.addHallSensorListener(index, new HallSensorListener() {

            @Override
            public void hallSensorTransition(HallTransitionImpl h) {
                ui.recordHallSensorPositions(index, h);
            }
        });
    }

    private static void createPositionCollector(final int index, final ShutterSimulator shutterSimulator, final ShutterUI ui) {
        shutterSimulator.addEncoderSimulatorListener(index, new EncoderSimulatorListener() {

            @Override
            public void encoderSimulatorReady(List<MotorPosition> h) {
                ui.recordMotorPositions(index, h);

            }
        });
    }
}
