package org.lsst.ccs.subsystems.shutter.gui;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;
import util.ListenerList;

/**
 *
 * @author azemoon
 */
public class MotorReadOut implements DiscretePlotData, MutablePlotData {

    private final List<readOut> history = new ArrayList<readOut>();
    private final ListenerList<PlotDataListener> listeners = new ListenerList<PlotDataListener>();
    private final String[] names = {"Time", "Position"};
    private static double ERROR = 0.02;
    private long startTime = 0;

    public void MotorReadOut() {
    }

    public void reset() {
       history.clear();
       startTime = 0;
       firePlotDataChanged();
    }

    public void addData(List<MotorPosition> h, long t0) {
       startTime = t0;
       for ( MotorPosition p : h){
           double t = (p.getTime() - startTime) / 1000.;
           System.out.println("UI : set 0 Time"  + p.getTime() + " smeared position " + p.getPosition() );
           //System.out.println("MotorReadOut: time " + time + " position " + position);
           history.add(new readOut(t, p.getPosition(), ERROR));
      }
        firePlotDataChanged();
    }

    @Override
    public int getNPoints() {
        return history.size();
    }

    @Override
    public int getNDimensions() {
        return names.length;
    }

    @Override
    public String names(int index) {
        return names[index];
    }

    @Override
    public Class types(int index) {
        return Double.TYPE;
    }

    @Override
    public void getValue(Value value, int dim, int index) {
        readOut mp = history.get(index);
        switch (dim) {
            case 0: value.set(mp.getTime()); break;
            case 1: value.set(mp.getPosition()); break;
            case 2: value.set(mp.getError()); break;
        }
    }

    @Override
    public MetaData getMetaData() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Motor Readout";
    }

    @Override
    public SuggestedRange getSuggestedRange() {
        return null;
    }

    @Override
    public void addPlotDataListener(PlotDataListener listener) {
        listeners.addListener(listener);
    }

    @Override
    public void removePlotDataListener(PlotDataListener listener) {
        listeners.removeListener(listener);
    }

    private void firePlotDataChanged() {
        if (!listeners.isEmpty()) {
            for (PlotDataListener l : listeners.getListeners()) {
                l.dataChanged();
            }
        }
    }

    @Override
    public Object lock() {
        return history;
    }

    public long getStartTime() {
        return startTime;
    }

    private static class readOut {

        private double time;
        private double position;
        private double error;

        public readOut(double time, double position, double error) {
            this.time = time;
            this.position = position;
            this.error = error;
        }

        public double getTime() {
            return time;
        }

        public double getPosition() {
            return position;
        }

        public double getError() {
            return error;
        }
    }

}
