package org.lsst.ccs.subsystems.shutter.common;

import data.DiscretePlotData;
import data.MetaData;
import data.SuggestedRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;

/**
 *
 * @author tonyj
 */
public class MotorHistory implements DiscretePlotData, Serializable {

    private List<MotorSpeed> history = new ArrayList<MotorSpeed>();
//    private final ListenerList<PlotDataListener> listeners = new ListenerList<PlotDataListener>();
    private final String[] names = {"Time", "Acceleration", "Velocity", "Position"};

    public MotorHistory() {
    }


    public List<MotorSpeed> getList() {
        return history;
    }

    public void setList(List<MotorSpeed> list) {
        this.history = list;
    }


    public void reset() {
       history.clear();
//       firePlotDataChanged();
    }

    public void addData(double time, double acceleration, double velocity, double position) {
        history.add(new MotorSpeed(time,acceleration,velocity,position));
//        firePlotDataChanged();
    }

    @Override
    public int getNPoints() {
        return history.size();
    }

    @Override
    public int getNDimensions() {
        return names.length;
    }

    @Override
    public String names(int index) {
        return names[index];
    }

    @Override
    public Class types(int index) {
        return Double.TYPE;
    }

    @Override
    public void getValue(Value value, int dim, int index) {
        MotorSpeed speed = history.get(index);
        switch (dim) {
            case 0: value.set(speed.getDate()); break;
            case 1: value.set(speed.getAcceleration()); break;
            case 2: value.set(speed.getVelocity()); break;
            case 3: value.set(speed.getPosition()); break;
        }
    }

    @Override
    public MetaData getMetaData() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Motor History";
    }

    @Override
    public SuggestedRange getSuggestedRange() {
        return null;
    }

//    @Override
//    public void addPlotDataListener(PlotDataListener listener) {
//        listeners.addListener(listener);
//    }
//
//    @Override
//    public void removePlotDataListener(PlotDataListener listener) {
//        listeners.removeListener(listener);
//    }
//
//    private void firePlotDataChanged() {
//        if (!listeners.isEmpty()) {
//            for (PlotDataListener l : listeners.getListeners()) {
//                l.dataChanged();
//            }
//        }
//    }

//    @Override
//    public Object lock() {
//        return history;
//    }

    private static class MotorSpeed implements Serializable {

        private double date;
        private double acceleration;
        private double velocity;
        private double position;

        public MotorSpeed(double date, double acceleration, double velocity, double position) {
            this.date = date;
            this.acceleration = acceleration;
            this.velocity = velocity;
            this.position = position;
        }

        public double getAcceleration() {
            return acceleration;
        }

        public double getDate() {
            return date;
        }

        public double getPosition() {
            return position;
        }

        public double getVelocity() {
            return velocity;
        }
    }
}
