/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.shutter.common.MotorStatus;
import org.lsst.ccs.subsystems.shutter.status.DriverStatus;
import org.lsst.ccs.subsystems.shutter.status.ShutterStatus;
import org.lsst.ccs.subsystems.shutter.ui.PlotPanel;
import org.lsst.ccs.subsystems.shutter.ui.ShutterAssembly;
import org.lsst.ccs.subsystems.shutter.ui.ShutterControlPanel;

public class ShutterUIModule
extends Subsystem {
    ShutterAssembly assembly;
    ShutterControlPanel control;
    PlotPanel plotPanel;
    ShutterStatus currentShutterStatus = null;

    public ShutterUIModule() {
        Subsystem.log.info((Object)"[ShutterUIModule] Initializing the Shutter UI module ");
        this.assembly = new ShutterAssembly();
        this.control = new ShutterControlPanel();
        this.plotPanel = new PlotPanel();
        this.setName("ShutterUIModule");
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.start();
    }

    public String getStatusBusSelector() {
        return "origin=ccs-shutter";
    }

    public static void main(String[] args) {
        ShutterUIModule t = new ShutterUIModule();
        t.openDisplay();
    }

    public void openDisplay() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        panel.add((Component)this.plotPanel, c);
        panel.add((Component)this.assembly, c);
        panel.add((Component)this.control, c);
        JFrame frame = new JFrame("Shutter UI");
        frame.getRootPane().setDoubleBuffered(true);
        frame.setContentPane(panel);
        frame.setResizable(false);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private void updateShutterStatus(ShutterStatus newStatus) {
        if (this.currentShutterStatus == null || !newStatus.equals((Object)this.currentShutterStatus)) {
            this.currentShutterStatus = newStatus;
            this.control.setExposureTime(this.currentShutterStatus.getExposureTimeSeconds());
            this.control.setMovementTime(this.currentShutterStatus.getMoveTimeSeconds());
            this.control.setEnabled(this.currentShutterStatus.getState().equals((Object)State.Ready));
        }
    }

    private void updateDisplay(DriverStatus s) {
        this.plotPanel.clearPlot();
        this.plotPanel.setTimePeriod(s.getExposureTime() + s.getOpenTime());
        if (s.isFirstBladeInOpenPosition()) {
            this.assembly.getShutter(0).setShutterPosition(0.0f);
            this.assembly.getShutter(1).setShutterPosition(1.0f);
        } else {
            this.assembly.getShutter(1).setShutterPosition(0.0f);
            this.assembly.getShutter(0).setShutterPosition(1.0f);
        }
    }

    public void onStatus(BusMessage s) {
        if (s instanceof ShutterStatus) {
            ShutterStatus newStatus = (ShutterStatus)s;
            this.updateShutterStatus(newStatus);
        } else if (s instanceof DriverStatus) {
            DriverStatus driverStatus = (DriverStatus)s;
            this.updateDisplay(driverStatus);
        } else if (s instanceof MotorStatus) {
            final MotorStatus status = (MotorStatus)s;
            String motorName = status.getName();
            int motor = -1;
            if (motorName.contains("motor0")) {
                motor = 0;
            } else if (motorName.contains("motor1")) {
                motor = 1;
            }
            final int motorIndex = motor;
            if (motorIndex != -1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ShutterUIModule.this.plotPanel.plotMotorHistory(status.getHistory(), motorIndex);
                        float position = ShutterUIModule.this.assembly.getShutter(motorIndex).getShutterPosition();
                        ShutterUIModule.this.assembly.getShutter(motorIndex).setShutterPosition(position == 0.0f ? 1 : 0);
                        ShutterUIModule.this.assembly.repaint();
                    }
                });
            }
        }
    }

    public void onCommand(Command cmd) {
        System.out.println(cmd + " cmd correl(" + cmd.getCorrelId() + ")");
    }

    public void onReply(CommandReply cmd) {
        System.out.println(cmd + " reply correl(" + cmd.getCorrelId() + ")");
    }
}

