/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.ui;

import data.DiscretePlotData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.subsystems.shutter.common.MotorHistory;
import plotter.Axis;
import plotter.AxisModel;
import plotter.ContinuousAxisModel;
import plotter.DataArea;
import plotter.DataOverlay;
import plotter.LineChartOverlay;
import plotter.LinearAxisModel;
import plotter.PlotLayout;

public class PlotPanel
extends JPanel {
    private LinearAxisModel yAxisModel;
    private ContinuousAxisModel xAxisModel;
    private DataArea da;
    KeyPanel[] keyPanels = new KeyPanel[2];
    private JPanel plotPanel;
    private MotorHistory[] histories = new MotorHistory[2];

    PlotPanel() {
        super(new GridBagLayout());
        this.plotPanel = new JPanel((LayoutManager)new PlotLayout());
        this.plotPanel.setPreferredSize(new Dimension(500, 300));
        this.xAxisModel = new LinearAxisModel(-1.1, 1.1);
        this.yAxisModel = new LinearAxisModel(0.0, 5.0);
        Axis xAxis = new Axis((AxisModel)this.xAxisModel, Axis.AxisPosition.LEFT);
        Axis yAxis = new Axis((AxisModel)this.yAxisModel, Axis.AxisPosition.BOTTOM);
        this.da = new DataArea(yAxis, xAxis);
        this.plotPanel.add((Component)xAxis);
        this.plotPanel.add((Component)yAxis);
        this.plotPanel.add((Component)this.da);
        this.keyPanels[0] = new KeyPanel("Motor 1");
        this.keyPanels[1] = new KeyPanel("Motor 2");
        this.histories[0] = new MotorHistory();
        this.histories[1] = new MotorHistory();
        MotorHistory motor1 = this.histories[0];
        LineChartOverlay acceleration1 = new LineChartOverlay("Acceleration", (DiscretePlotData)motor1, 0, 1, (ContinuousAxisModel)this.yAxisModel, this.xAxisModel);
        this.da.add((DataOverlay)acceleration1);
        acceleration1.setLineColor(Color.RED);
        LineChartOverlay velocity1 = new LineChartOverlay("Velocity", (DiscretePlotData)motor1, 0, 2, (ContinuousAxisModel)this.yAxisModel, this.xAxisModel);
        this.da.add((DataOverlay)velocity1);
        velocity1.setLineColor(Color.BLUE);
        LineChartOverlay position1 = new LineChartOverlay("Position", (DiscretePlotData)motor1, 0, 3, (ContinuousAxisModel)this.yAxisModel, this.xAxisModel);
        this.da.add((DataOverlay)position1);
        position1.setLineColor(Color.GREEN);
        this.keyPanels[0].add(acceleration1);
        this.keyPanels[0].add(velocity1);
        this.keyPanels[0].add(position1);
        MotorHistory motor2 = this.histories[1];
        LineChartOverlay acceleration2 = new LineChartOverlay("Acceleration", (DiscretePlotData)motor2, 0, 1, (ContinuousAxisModel)this.yAxisModel, this.xAxisModel);
        this.da.add((DataOverlay)acceleration2);
        acceleration2.setLineColor(Color.ORANGE);
        LineChartOverlay velocity2 = new LineChartOverlay("Velocity", (DiscretePlotData)motor2, 0, 2, (ContinuousAxisModel)this.yAxisModel, this.xAxisModel);
        this.da.add((DataOverlay)velocity2);
        velocity2.setLineColor(Color.CYAN);
        LineChartOverlay position2 = new LineChartOverlay("Position", (DiscretePlotData)motor2, 0, 3, (ContinuousAxisModel)this.yAxisModel, this.xAxisModel);
        this.da.add((DataOverlay)position2);
        position2.setLineColor(Color.MAGENTA);
        this.keyPanels[1].add(acceleration2);
        this.keyPanels[1].add(velocity2);
        this.keyPanels[1].add(position2);
        JPanel key = new JPanel(new BorderLayout());
        key.add("North", this.keyPanels[0]);
        key.add("South", this.keyPanels[1]);
        key.setBorder(BorderFactory.createTitledBorder("Key"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        this.add((Component)this.plotPanel, c);
        this.add((Component)key, c);
    }

    public void clearPlot() {
        this.histories[0].reset();
        this.histories[1].reset();
        this.repaint();
    }

    public void plotMotorHistory(MotorHistory history, int motor) {
        this.histories[motor].setList(history.getList());
        this.repaint();
    }

    void setTimePeriod(double time) {
        this.yAxisModel.setMax(time);
        this.repaint();
    }

    private static class KeyPanel
    extends JPanel {
        KeyPanel(String title) {
            super(new FlowLayout());
            this.add(new JLabel(title));
        }

        private void add(LineChartOverlay overlay) {
            JLabel label = new JLabel(overlay.getTitle());
            label.setIcon(overlay.getKeyIcon());
            this.add(label);
        }
    }
}

