/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.simulator.motor;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lsst.ccs.subsystems.shutter.simulator.motor.EncoderSimulatorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorSimulator;

public class MotorEncoderSimulator {
    private List<MotorPosition> history = new ArrayList<MotorPosition>();
    private List<EncoderSimulatorListener> listeners = new ArrayList<EncoderSimulatorListener>();
    private final MotorSimulator simulator;
    private long nextPublishTime = 0L;
    private long samplingInterval = 100L;

    public MotorEncoderSimulator(MotorSimulator simulator) {
        System.out.println("MotorPositionCollector STARTED ************** ");
        this.simulator = simulator;
        simulator.addMotorListener(new MotorListener(){
            final Random random = new Random();

            @Override
            public void positionChanged(MotorPosition p) {
                if (p.getTime() > MotorEncoderSimulator.this.nextPublishTime) {
                    MotorEncoderSimulator.this.smearAndAdd(p, this.random);
                    MotorEncoderSimulator.this.nextPublishTime = p.getTime() + MotorEncoderSimulator.this.samplingInterval;
                }
            }

            @Override
            public void motorStopped() {
                MotorEncoderSimulator.this.fireEncoderSimulatorReadyEvent();
                MotorEncoderSimulator.this.history.clear();
                MotorEncoderSimulator.this.nextPublishTime = 0L;
            }
        });
    }

    private void smearAndAdd(MotorPosition p, Random random) {
        double delta = random.nextGaussian() * 0.02;
        double position = p.getPosition() + delta;
        p.setPosition((float)position);
        this.history.add(p);
    }

    public MotorSimulator getMotorSimulator() {
        return this.simulator;
    }

    public void addEncoderSimulatorListener(EncoderSimulatorListener l) {
        this.listeners.add(l);
    }

    public void removeEncoderSimulatorListener(EncoderSimulatorListener l) {
        this.listeners.remove(l);
    }

    private void fireEncoderSimulatorReadyEvent() {
        for (EncoderSimulatorListener l : new ArrayList<EncoderSimulatorListener>(this.listeners)) {
            l.encoderSimulatorReady(this.history);
        }
    }
}

