/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.simulator.motor;

import java.util.List;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.lsst.ccs.subsystems.shutter.simulator.motor.EncoderSimulatorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.HallSensorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.HallSensorSimulator;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorEncoderSimulator;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorSimulator;

public class BladeSetSimulator {
    private EventListenerList listeners = new EventListenerList();
    private MotorSimulator motorSimulator = new MotorSimulator();
    private MotorEncoderSimulator encoderSimulator = new MotorEncoderSimulator(this.motorSimulator);
    private HallSensorSimulator hallSensorSimulator = new HallSensorSimulator(this.motorSimulator);
    private int index;

    public float getCurrentPosition() {
        return (float)this.motorSimulator.getInitialMotorPosition();
    }

    public void setIndex(int index) {
        this.index = index;
        if (index == 0) {
            this.motorSimulator.setInitialMotorPosition(0.0);
        } else {
            this.motorSimulator.setInitialMotorPosition(1.0);
        }
    }

    public void start() {
    }

    public double getBladeSetPosition() {
        return this.motorSimulator.getInitialMotorPosition();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    public void addEncoderSimulatorListener(EncoderSimulatorListener l) {
        this.encoderSimulator.addEncoderSimulatorListener(l);
    }

    public void removeEncoderSimulatorListener(EncoderSimulatorListener l) {
        this.encoderSimulator.removeEncoderSimulatorListener(l);
    }

    public void addHallSensorListener(HallSensorListener l) {
        this.hallSensorSimulator.addHallSensorListener(l);
    }

    public void removeHallSensorListener(HallSensorListener l) {
        this.hallSensorSimulator.removeHallSensorListener(l);
    }

    public void moveToPosition(float targetPosition, float moveTimeSeconds) {
        this.encoderSimulator.addEncoderSimulatorListener(new EncoderSimulatorListener(){

            @Override
            public void encoderSimulatorReady(List<MotorPosition> h) {
                BladeSetSimulator.this.encoderSimulator.removeEncoderSimulatorListener(this);
            }
        });
        this.motorSimulator.simulateMovement(targetPosition, moveTimeSeconds);
    }
}

