/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.simulator;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;
import org.lsst.ccs.subsystems.shutter.interfaces.BladePosition;
import util.ListenerList;

public class EncoderReadOut
implements DiscretePlotData,
MutablePlotData {
    private final List<readOut> history = new ArrayList<readOut>();
    private final ListenerList<PlotDataListener> listeners = new ListenerList();
    private final String[] names = new String[]{"Time", "Position"};
    private static double ERROR = 0.02;
    private long startTime = 0L;

    public void EncoderReadOut() {
    }

    public void reset() {
        this.history.clear();
        this.startTime = 0L;
        this.firePlotDataChanged();
    }

    public void addData(List<BladePosition> h, long t0) {
        this.startTime = t0;
        for (BladePosition p : h) {
            double t = (double)(p.getTime() - this.startTime) / 1000.0;
            System.out.println("EncoderReadOut : set 0 Time" + p.getTime() + " smeared position " + p.getRelPosition());
            this.history.add(new readOut(t, p.getRelPosition(), ERROR));
        }
        this.firePlotDataChanged();
    }

    public int getNPoints() {
        return this.history.size();
    }

    public int getNDimensions() {
        return this.names.length;
    }

    public String names(int index) {
        return this.names[index];
    }

    public Class types(int index) {
        return Double.TYPE;
    }

    public void getValue(Value value, int dim, int index) {
        readOut mp = this.history.get(index);
        switch (dim) {
            case 0: {
                value.set(mp.getTime());
                break;
            }
            case 1: {
                value.set(mp.getPosition());
                break;
            }
            case 2: {
                value.set(mp.getError());
            }
        }
    }

    public MetaData getMetaData() {
        return null;
    }

    public String getTitle() {
        return "Motor Readout";
    }

    public SuggestedRange getSuggestedRange() {
        return null;
    }

    public void addPlotDataListener(PlotDataListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removePlotDataListener(PlotDataListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void firePlotDataChanged() {
        if (!this.listeners.isEmpty()) {
            for (PlotDataListener l : this.listeners.getListeners()) {
                l.dataChanged();
            }
        }
    }

    public Object lock() {
        return this.history;
    }

    public long getStartTime() {
        return this.startTime;
    }

    private static class readOut {
        private double time;
        private double position;
        private double error;

        public readOut(double time, double position, double error) {
            this.time = time;
            this.position = position;
            this.error = error;
        }

        public double getTime() {
            return this.time;
        }

        public double getPosition() {
            return this.position;
        }

        public double getError() {
            return this.error;
        }
    }
}

