/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.subsystems.shutter.common.HallTransitionImpl;
import org.lsst.ccs.subsystems.shutter.gui.ShutterControlPanel;
import org.lsst.ccs.subsystems.shutter.gui.ShutterUI;
import org.lsst.ccs.subsystems.shutter.simulator.motor.EncoderSimulatorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.HallSensorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;
import org.lsst.ccs.subsystems.shutter.simulator.motor.ShutterSimulator;

public class StandaloneShutterDemo {
    public static void main(String[] args) {
        StandaloneShutterDemo demo = new StandaloneShutterDemo();
        demo.start();
    }

    public void start() {
        ShutterUI ui = new ShutterUI();
        ShutterControlPanel control = new ShutterControlPanel();
        ShutterSimulator shutterSimulator = new ShutterSimulator();
        StandaloneShutterDemo.shortCircuitMMS(control, shutterSimulator, ui);
        shutterSimulator.start();
        JFrame frame = new JFrame("Shutter GUI demo");
        frame.getRootPane().setDoubleBuffered(true);
        frame.getContentPane().add((Component)ui, "Center");
        frame.getContentPane().add((Component)control, "South");
        frame.setDefaultCloseOperation(3);
        frame.setResizable(true);
        frame.pack();
        frame.setVisible(true);
    }

    public static void shortCircuitMMS(final ShutterControlPanel control, final ShutterSimulator shutterSimulator, final ShutterUI ui) {
        control.addTakeImageActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shutterSimulator.takeImage(control.getMovementTime(), control.getExposureTime());
                ui.takeImage(control.getMovementTime(), control.getExposureTime());
            }
        });
        control.addMoveToActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shutterSimulator.moveToPosition(control.getBladeSetIndex(), control.getTargetPosition(), control.getMovementTime(), true);
                ui.moveToPosition(control.getBladeSetIndex(), control.getTargetPosition(), control.getMovementTime());
            }
        });
        control.addCloseShutterActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shutterSimulator.closeShutter();
                ui.closeShutter();
            }
        });
        ui.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                control.setEnabled(!ui.isInMotion());
            }
        });
        StandaloneShutterDemo.createPositionCollector(0, shutterSimulator, ui);
        StandaloneShutterDemo.createPositionCollector(1, shutterSimulator, ui);
        StandaloneShutterDemo.createHallSensorListener(0, shutterSimulator, ui);
        StandaloneShutterDemo.createHallSensorListener(1, shutterSimulator, ui);
    }

    private static void createHallSensorListener(final int index, ShutterSimulator shutterSimulator, final ShutterUI ui) {
        shutterSimulator.addHallSensorListener(index, new HallSensorListener(){

            @Override
            public void hallSensorTransition(HallTransitionImpl h) {
                ui.recordHallSensorPositions(index, h);
            }
        });
    }

    private static void createPositionCollector(final int index, ShutterSimulator shutterSimulator, final ShutterUI ui) {
        shutterSimulator.addEncoderSimulatorListener(index, new EncoderSimulatorListener(){

            @Override
            public void encoderSimulatorReady(List<MotorPosition> h) {
                ui.recordMotorPositions(index, h);
            }
        });
    }
}

