/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.lsst.ccs.subsystems.shutter.common.HallTransitionImpl;
import org.lsst.ccs.subsystems.shutter.gui.HallSensorHistory;
import org.lsst.ccs.subsystems.shutter.gui.MotorHistory;
import org.lsst.ccs.subsystems.shutter.gui.MotorReadOut;
import org.lsst.ccs.subsystems.shutter.gui.PlotPanel;
import org.lsst.ccs.subsystems.shutter.gui.ShutterAssembly;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorSimulator;

public class ShutterUI
extends JPanel {
    static final double MAXCLOSETIME = 2.0;
    private final ShutterAssembly assembly;
    private PlotPanel plotPanel;
    private List<MotorHistory> motorHistories = new ArrayList<MotorHistory>();
    private List<HallSensorHistory> hallSensorHistories = new ArrayList<HallSensorHistory>();
    private List<MotorReadOut> motorReadOuts = new ArrayList<MotorReadOut>();
    private boolean inMotion = false;
    private boolean finalize = true;
    private EventListenerList listeners = new EventListenerList();
    private List<MotorSimulator> simulators = new ArrayList<MotorSimulator>();

    public ShutterUI() {
        super(new BorderLayout());
        this.simulators.add(new MotorSimulator());
        this.simulators.add(new MotorSimulator());
        this.assembly = new ShutterAssembly();
        this.motorHistories.add(new MotorHistory());
        this.motorHistories.add(new MotorHistory());
        this.hallSensorHistories.add(new HallSensorHistory());
        this.hallSensorHistories.add(new HallSensorHistory());
        this.motorReadOuts.add(new MotorReadOut());
        this.motorReadOuts.add(new MotorReadOut());
        this.plotPanel = new PlotPanel(this.motorHistories, this.hallSensorHistories, this.motorReadOuts);
        JSplitPane split = new JSplitPane(1);
        split.add(this.plotPanel);
        split.add(this.assembly);
        this.add((Component)split, "Center");
        this.simulators.get(0).setInitialMotorPosition(this.assembly.getShutter(0).getShutterPosition());
        this.simulators.get(1).setInitialMotorPosition(this.assembly.getShutter(1).getShutterPosition());
    }

    List<MotorHistory> getHistories() {
        return this.motorHistories;
    }

    public boolean isInMotion() {
        return this.inMotion;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    private void fireChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        ChangeListener[] changeListenerArray = (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
        int n = changeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeListener l = changeListenerArray[n2];
            l.stateChanged(e);
            ++n2;
        }
    }

    public void moveToPosition(final int index, float targetPosition, float moveTimeSeconds, boolean initialize) {
        float safeTargetPosition;
        boolean retractBladeSet;
        float currentPosition = this.assembly.getShutter(index).getShutterPosition();
        System.out.println("UI: currentPosition " + currentPosition + "targetPosition  " + targetPosition);
        boolean bl = retractBladeSet = targetPosition < currentPosition;
        if (initialize) {
            this.hallSensorHistories.get(index).setStartPosition(currentPosition);
            int i = 0;
            while (i <= 1) {
                this.motorHistories.get(i).reset();
                this.hallSensorHistories.get(i).reset();
                this.motorReadOuts.get(i).reset();
                ++i;
            }
        } else {
            this.hallSensorHistories.get(index).setStartTime(this.hallSensorHistories.get(1 - index).getStartTime());
            this.motorHistories.get(index).setStartTime(this.motorHistories.get(1 - index).getStartTime());
        }
        if (!retractBladeSet && initialize && targetPosition > (safeTargetPosition = 1.0f - this.assembly.getShutter(1 - index).getShutterPosition())) {
            System.out.printf("Unsafe operation, end position modified \n", new Object[0]);
            targetPosition = safeTargetPosition;
            System.out.println("UI: currentPosition " + currentPosition + "targetPosition  " + targetPosition);
        }
        final MotorSimulator motor = this.simulators.get(index);
        motor.addMotorListener(new MotorListener(){

            @Override
            public void positionChanged(MotorPosition p) {
                ShutterUI.this.assembly.getShutter(index).setShutterPosition((float)p.getPosition());
                ShutterUI.this.assembly.repaint();
                ((MotorHistory)ShutterUI.this.motorHistories.get(index)).addData(p.getTime(), p.getAcceleration(), p.getVelocity(), p.getPosition());
            }

            @Override
            public void motorStopped() {
                if (ShutterUI.this.finalize) {
                    ShutterUI.this.inMotion = false;
                    ShutterUI.this.fireChangeListeners();
                }
                motor.removeMotorListener(this);
            }
        });
        this.inMotion = true;
        this.fireChangeListeners();
        motor.simulateMovement(targetPosition, (long)moveTimeSeconds);
    }

    void takeImage(int firstMotorIndex, final float moveTimeSeconds, float exposureTimeSeconds) {
        this.plotPanel.setTimePeriod(moveTimeSeconds + exposureTimeSeconds);
        int exposureTime = (int)(1000.0f * exposureTimeSeconds);
        final int secondMotorIndex = 1 - firstMotorIndex;
        this.inMotion = true;
        this.fireChangeListeners();
        Timer timer1 = new Timer(exposureTime, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShutterUI.this.finalize = true;
                ShutterUI.this.moveToPosition(secondMotorIndex, 1.0f, moveTimeSeconds, false);
            }
        });
        timer1.setRepeats(false);
        timer1.start();
        this.finalize = false;
        this.moveToPosition(firstMotorIndex, 0.0f, moveTimeSeconds, true);
    }

    void moveToPosition(int bladeSetIndex, float targetPosition, float movementTime) {
        this.plotPanel.setTimePeriod(movementTime);
        this.moveToPosition(bladeSetIndex, targetPosition, movementTime, true);
    }

    void takeImage(float moveTimeSeconds, float exposureTimeSeconds) {
        float position0 = this.assembly.getShutter(0).getShutterPosition();
        float position1 = this.assembly.getShutter(1).getShutterPosition();
        System.out.println("UI: " + position0 + " " + position1 + " *******");
        if (position0 == 0.0f && position1 == 1.0f || position0 == 1.0f && position1 == 0.0f) {
            int firstMotorIndex = position0 < position1 ? 1 : 0;
            this.takeImage(firstMotorIndex, moveTimeSeconds, exposureTimeSeconds);
        } else {
            System.out.println(" ****** Shutter not ready for taking image.******");
        }
    }

    public void closeShutter() {
        float position0 = this.assembly.getShutter(0).getShutterPosition();
        float position1 = this.assembly.getShutter(1).getShutterPosition();
        if (position0 == 0.0f && position1 == 1.0f || position0 == 1.0f && position1 == 0.0f) {
            System.out.println("Shutter already closed ***** ");
        } else {
            int firstBladeSetIndex = position0 < position1 ? 0 : 1;
            final int secondBladeSetIndex = 1 - firstBladeSetIndex;
            if (position0 == 0.0f || position1 == 0.0f) {
                this.moveToPosition(secondBladeSetIndex, 1.0f, 2.0f, true);
            } else {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ShutterUI.this.moveToPosition(secondBladeSetIndex, 1.0f, 2.0f, false);
                    }
                });
                t.start();
                this.moveToPosition(firstBladeSetIndex, 0.0f, 2.0f, true);
            }
        }
    }

    void recordMotorPositions(int motorIndex, List<MotorPosition> h) {
        int otherMotorIndex = 1 - motorIndex;
        long t0 = this.motorReadOuts.get(otherMotorIndex).getStartTime() > 0L ? this.motorReadOuts.get(otherMotorIndex).getStartTime() : h.get(0).getTime();
        this.motorReadOuts.get(motorIndex).addData(h, t0);
    }

    void recordHallSensorPositions(int sensorIndex, HallTransitionImpl h) {
        this.hallSensorHistories.get(sensorIndex).addData(h.getTransitionTime(), h.getPosition());
    }
}

