/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.driver;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Scanner;
import org.lsst.ccs.drivers.iocard.AccesDio;
import org.lsst.ccs.drivers.iocard.Helios;
import org.lsst.ccs.drivers.parker.AcrComm;
import org.lsst.ccs.drivers.parker.TestAcrComm;
import org.lsst.ccs.subsystems.shutter.common.BladePositionImpl;
import org.lsst.ccs.subsystems.shutter.driver.BladeSetCalibration;
import org.lsst.ccs.subsystems.shutter.driver.BladeSetConfigurationDrvr;
import org.lsst.ccs.subsystems.shutter.driver.BladeSetDrvr;
import org.lsst.ccs.subsystems.shutter.driver.MovementStatus;
import org.lsst.ccs.subsystems.shutter.interfaces.BladePosition;
import org.lsst.ccs.subsystems.shutter.interfaces.HallTransition;
import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistory;
import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistoryListener;
import org.lsst.ccs.utilities.sa.CmndProc;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestBladeSet
implements CmndProc.Dispatch,
MovementHistoryListener {
    private static final int DRV_OFF = 0;
    private static final int DRV_ON = 1;
    private static final int TEST_PROG = 2;
    private static final int CMD_CALIB = 0;
    private static final int CMD_STEP = 1;
    private static final int CMD_HOME = 2;
    private static final int CMD_MOVE = 3;
    private static final int CMD_MOVEP = 4;
    private static final int CMD_MOVEH = 5;
    private static final int CMD_MOVED = 6;
    private static final int CMD_CALREAD = 7;
    private static final int CMD_CALSHOW = 8;
    private static final int CMD_PULSE = 9;
    private static final int CMD_CALTEST = 10;
    private static final int CMD_MOVEX = 11;
    private static final int CMD_THRSHOW = 12;
    private static final int CMD_TIMESYNC = 13;
    private static final int CMD_HALLTEST = 14;
    private static final int CMD_DRIVE = 15;
    private static final int CMD_MOVETEST = 16;
    private static final int CMD_ENCTEST = 17;
    private static final int CMD_POSITION = 18;
    private static final int CMD_CONFSHOW = 19;
    private static final int CMD_TEMPSHOW = 20;
    private static final int NUM_CMDS = 21;
    private static final String[] helpConfshow = new String[]{"Show the blade configuration data", "confshow"};
    private static final String[] helpDrive = new String[]{"Set drive state", "drive  <state>", "state  The state to set, either 'on' or 'off'"};
    private static final String[] helpCalib = new String[]{"Calibrate Hall switch positions", "calibrate <dist> <step> [<time>] [<file>]", "dist    The total distance to travel (mm)", "step    The step size (mm)", "time    The time for each step (sec) (default 0.1)", "file    The base name of the file to receive the calibration data"};
    private static final String[] helpCaltest = new String[]{"Calibrate Hall switch positions (new calibration test)", "caltest <type> <dist> [<time>] [<file>]", "type    The test type: 0 = new cal; 1 = cap test 1; 2 = cap test 2", "dist    The distance to move (mm)", "time    The time for the move (sec) (default 10)", "file    The base name of the file to receive the calibration data"};
    private static final String[] helpCalread = new String[]{"Read file of Hall switch positions", "calread [<file>]", "file    The name of the file containing the calibration data"};
    private static final String[] helpCalshow = new String[]{"Show the Hall switch position data", "calshow"};
    private static final String[] helpPosition = new String[]{"Position the shutter blade set at a fraction of its full extent", "position [<posn>] [<time>]", "posn    The position to move to (0 - 1); if absent, display it", "time    The time for the move (secs) (default 1.0)"};
    private static final String[] helpMove = new String[]{"Move the shutter blade set", "move [<dist>] [<time>] [<type>] [<mvfrac>]", "dist    The distance to move (mm); if absent, display position", "time    The time for the move (secs) (default 1.0)", "type    The type of move to make: 'trap' or 'scurve' (default)", "mvfrac  The fraction of the time at maximum velocity (default 0)"};
    private static final String[] helpMoved = new String[]{"Move the shutter blade set, recording various data values", "moved [<dist>] [<time>] [<nsamp>] [<type>] [<mvfrac>] [<name>]", "dist    The distance to move (mm); if absent, display position", "time    The time for the move (secs) (default 1.0)", "nsamp   The number of times to sample the position (default 100)", "type    The type of move to make: 'trap' or 'scurve' (default)", "mvfrac  The fraction of the time at maximum velocity (default 0)", "name    The root part of the name of the output data file"};
    private static final String[] helpMoveh = new String[]{"Move the shutter blade set, recording Hall switch times", "moveh [<dist>] [<time>] [<nsamp>] [<type>] [<mvfrac>] [<name>]", "dist    The distance to move (mm); if absent, display position", "time    The time for the move (secs) (default 1.0)", "nsamp   The number of times to sample the position (default 100)", "type    The type of move to make: 'trap' or 'scurve' (default)", "mvfrac  The fraction of the time at maximum velocity (default 0)", "name    The root part of the name of the output data files"};
    private static final String[] helpMovep = new String[]{"Move the shutter blade set, recording sampled positions", "movep [<dist>] [<time>] [<nsamp>] [<type>] [<mvfrac>] [<name>]", "dist    The distance to move (mm); if absent, display position", "time    The time for the move (secs) (default 1.0)", "nsamp   The number of times to sample the position (default 100)", "type    The type of move to make: 'trap' or 'scurve' (default)", "mvfrac  The fraction of the time at maximum velocity (default 0)", "name    The root part of the name of the output data file"};
    private static final String[] helpMovex = new String[]{"Move the shutter blade set, recording test values", "movex [<dist>] [<time>] [<nsamp>] [<type>] [<mvfrac>] [<name>]", "dist    The distance to move (mm); if absent, display position", "time    The time for the move (secs) (default 1.0)", "nsamp   The number of times to sample the position (default 100)", "type    The type of move to make: 'trap' or 'scurve' (default)", "mvfrac  The fraction of the time at maximum velocity (default 0)", "name    The root part of the name of the output data file"};
    private static final String[] helpMovetest = new String[]{"Move the shutter blade set repeatedly", "movetest <count> <dist> [<time>]", "count   The number of back-and-forth cycles to perform", "dist    The distance to move (mm)", "time    The time for each move (secs) (default 1.0)"};
    private static final String[] helpHalltest = new String[]{"Move the shutter blade set repeatedly, recording Hall switch times", "halltest <count> <dist> [<time>] [<name>]", "count   The number of back-and-forth cycles to perform", "dist    The distance to move (mm)", "time    The time for each move (secs) (default 1.0)", "name    The root part of the name of the output data file"};
    private static final String[] helpEnctest = new String[]{"Move the shutter blade set repeatedly, recording encoder profiles", "enctest <count> <dist> [<time>] [<nsamp>] [<name>]", "count   The number of back-and-forth cycles to perform", "dist    The distance to move (mm)", "time    The time for each move (secs) (default 1.0)", "nsamp   The number of times to sample the position (default 100)", "name    The root part of the name of the output data file"};
    private static final String[] helpStep = new String[]{"Step the motor, recording actual steps", "step <count> <step> [<time>]", "count  The number of steps to take", "step   The step size (encoder counts)", "time   The time for each step (sec) (default 0.1)"};
    private static final String[] helpHome = new String[]{"Find the home position", "home [<optns>] [<vel>]", "optns  Bit mask of options: 1 = neg. dirn.; 2 = pos. final (dflt 0)", "vel    Velocity (mm/sec) (default 10)"};
    private static final String[] helpPulse = new String[]{"Start or stop regular pulse on DIO line", "pulse <freq> [<line>] [<count>] [<fract>]", "freq   The pulse frequency; 0 = off", "line   The digital output line to use (default: ACR line)", "count  If >= 0, the maximum number of pulses to generate (default -1)", "fract  The fraction of time the pulse is on (default 0.5)"};
    private static final String[] helpTimesync = new String[]{"Time the synchronization between computer and motor controller", "timesync  [<capt>] [<count>]", "capt   If non-zero, use capture for synch'ing (default not)", "count  The number of pulses to generate (default 10)"};
    private static final String[] helpTempshow = new String[]{"Show the drive and ambient temperatures", "tempshow"};
    private static final String[] helpThrshow = new String[]{"Show thread information", "thrshow"};
    private final Output out;
    private final CmndProc.Lookup moveTypes;
    private final CmndProc.Lookup driveTypes;
    private final int dioOPort;
    private final int dioOLine;
    private final int dioIPort;
    private final int dioILine;
    private final int bladeIndex;
    private final BladeSetDrvr blade;
    private final CmndProc proc;
    private final BladeSetConfigurationDrvr config;
    private final TestAcrComm tacr;
    private final AccesDio acd;
    private final Helios hel;
    private final AcrComm acr;
    private String moveName = "Move_";
    private String calibName = "Calib_";
    private String caltName = "Calt_";
    private String hallName = "Hall_";
    private String encName = "Enc_";
    private MovementHistory mhData;

    public TestBladeSet(int index, Output iOut) throws IOException {
        this.out = iOut != null ? iOut : new ConsOut();
        CmndProc.Command cmnd = new CmndProc.Command(21);
        cmnd.add("confshow", 19, helpConfshow);
        cmnd.add("drive", 15, helpDrive);
        cmnd.add("calibrate", 0, helpCalib);
        cmnd.add("caltest", 10, helpCaltest);
        cmnd.add("calread", 7, helpCalread);
        cmnd.add("calshow", 8, helpCalshow);
        cmnd.add("position", 18, helpPosition);
        cmnd.add("move", 3, helpMove);
        cmnd.add("moved", 6, helpMoved);
        cmnd.add("movep", 4, helpMovep);
        cmnd.add("movex", 11, helpMovex);
        cmnd.add("moveh", 5, helpMoveh);
        cmnd.add("movetest", 16, helpMovetest);
        cmnd.add("halltest", 14, helpHalltest);
        cmnd.add("enctest", 17, helpEnctest);
        cmnd.add("step", 1, helpStep);
        cmnd.add("home", 2, helpHome);
        cmnd.add("pulse", 9, helpPulse);
        cmnd.add("tempshow", 20, helpTempshow);
        cmnd.add("thrshow", 12, helpThrshow);
        cmnd.add("timesync", 13, helpTimesync);
        this.moveTypes = new CmndProc.Lookup(2);
        this.moveTypes.add("scurve", 0);
        this.moveTypes.add("trap", 1);
        this.driveTypes = new CmndProc.Lookup(2);
        this.driveTypes.add("on", 1);
        this.driveTypes.add("off", 0);
        this.proc = new CmndProc();
        this.proc.add((CmndProc.Dispatch)this, cmnd);
        this.bladeIndex = index;
        this.blade = new BladeSetDrvr();
        this.blade.setIndex(this.bladeIndex);
        this.blade.addMovementHistoryListener(this);
        this.config = this.blade.getConfig();
        this.dioOPort = this.config.getDioOPort();
        this.dioOLine = this.config.getDioOLine();
        this.dioIPort = this.config.getDioIPort();
        this.dioILine = this.config.getDioILine();
        this.acd = this.blade.getAcces();
        this.hel = this.blade.getHelios();
        this.acr = this.blade.getComm();
        this.tacr = new TestAcrComm(this.acr, this.proc, true, this.out);
    }

    public static void main(String[] args) {
        int index = 0;
        if (args.length != 0) {
            try {
                index = Integer.valueOf(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Blade set index is not an integer");
                System.exit(0);
            }
            if (index < 0 || index > 1) {
                System.out.println("Blade set index must be 0 or 1");
                System.exit(0);
            }
        }
        try {
            TestBladeSet test = new TestBladeSet(index, null);
            test.tacr.run();
        }
        catch (AcrComm.Exception e) {
            System.out.println((Object)e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        System.exit(0);
    }

    public void process(String command) {
        this.tacr.process(command);
    }

    public boolean dispatch(int code, Scanner scan) {
        Object[] args = new Object[16];
        switch (code) {
            case 19: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args) < 0) break;
                this.showConfig();
                break;
            }
            case 15: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"S", (Object[])args) < 0) break;
                int type = this.driveTypes.encode((String)args[0], true);
                if (type == 1) {
                    this.blade.setDriveOn();
                    break;
                }
                if (type != 0) break;
                this.blade.setDriveOff();
                break;
            }
            case 0: {
                float time;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"FFfs", (Object[])args);
                if (found < 0) break;
                float dist = ((Float)args[0]).floatValue();
                float step = ((Float)args[1]).floatValue();
                float f = time = (found & 4) != 0 ? ((Float)args[2]).floatValue() : 0.1f;
                if ((found & 8) != 0) {
                    this.calibName = String.valueOf((String)args[3]) + "_";
                }
                String file = this.genFileName(this.calibName, ".dat");
                this.calibrate(dist, step, time, file);
                break;
            }
            case 10: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IFfs", (Object[])args);
                if (found < 0) break;
                if ((found & 8) != 0) {
                    this.caltName = String.valueOf((String)args[3]) + "_";
                }
                int type = (Integer)args[0];
                float dist = ((Float)args[1]).floatValue();
                float time = (found & 4) != 0 ? ((Float)args[2]).floatValue() : 10.0f;
                String file = this.genFileName(String.valueOf(this.caltName) + type + "_", ".dat");
                if (type == 0) {
                    this.calTest(dist, time, file);
                    break;
                }
                if (type == 1 || type == 3) {
                    this.calTest1(type == 1, dist, time, file);
                    break;
                }
                if (type == 2) {
                    this.calTest2(dist, time, file);
                    break;
                }
                if (type == 4) {
                    this.calTest4(dist, time, file);
                    break;
                }
                this.out.println((Object)"Invalid caltest type");
                break;
            }
            case 7: {
                int count;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"s", (Object[])args);
                if (found < 0 || (count = (found & 1) != 0 ? this.config.readCalibration((String)args[0]) : this.config.readCalibration()) < 0) break;
                this.out.println((Object)(String.valueOf(count) + " lines read from calibration file"));
                break;
            }
            case 8: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args) < 0) break;
                this.showCalib();
                break;
            }
            case 18: {
                float time;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ffs", (Object[])args);
                if (found < 0) break;
                if ((found & 1) == 0) {
                    this.showRelPosition();
                    break;
                }
                float dist = ((Float)args[0]).floatValue();
                float f = time = (found & 2) != 0 ? ((Float)args[1]).floatValue() : this.config.getMoveTime();
                if ((found & 4) != 0) {
                    this.moveName = String.valueOf((String)args[2]) + "_";
                }
                this.position(dist, time, this.moveName);
                break;
            }
            case 3: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ffsf", (Object[])args);
                if (found < 0) break;
                if ((found & 1) == 0) {
                    this.showPosition();
                    break;
                }
                String sType = (found & 4) != 0 ? (String)args[2] : "scurve";
                int type = this.moveTypes.encode(sType, true);
                if (type < 0) break;
                float dist = ((Float)args[0]).floatValue();
                float time = (found & 2) != 0 ? ((Float)args[1]).floatValue() : this.config.getMoveTime();
                float mvFrac = (found & 8) != 0 ? ((Float)args[3]).floatValue() : 0.0f;
                this.move(type, dist, time, mvFrac);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                float mvFrac;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ffisfs", (Object[])args);
                if (found < 0) break;
                if ((found & 1) == 0) {
                    this.showPosition();
                    break;
                }
                float dist = ((Float)args[0]).floatValue();
                float time = (found & 2) != 0 ? ((Float)args[1]).floatValue() : this.config.getMoveTime();
                int nSamp = (found & 4) != 0 ? ((Integer)args[2]).intValue() : this.config.getNumSamp();
                String sType = (found & 8) != 0 ? (String)args[3] : "scurve";
                int type = this.moveTypes.encode(sType, true);
                if (type < 0) break;
                float f = mvFrac = (found & 0x10) != 0 ? ((Float)args[4]).floatValue() : 0.0f;
                if ((found & 0x20) != 0) {
                    this.moveName = String.valueOf((String)args[5]) + "_";
                }
                if (code == 6) {
                    this.moveD(type, dist, time, mvFrac, nSamp, this.moveName);
                    break;
                }
                if (code == 5) {
                    this.moveH(type, dist, time, mvFrac, nSamp, this.moveName);
                    break;
                }
                if (code == 4) {
                    this.moveP(type, dist, time, mvFrac, nSamp, this.moveName);
                    break;
                }
                this.moveX(type, dist, time, mvFrac, nSamp, this.moveName);
                break;
            }
            case 16: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IFf", (Object[])args);
                if (found < 0) break;
                int count = (Integer)args[0];
                float dist = ((Float)args[1]).floatValue();
                float time = (found & 4) != 0 ? ((Float)args[2]).floatValue() : this.config.getMoveTime();
                this.moveTest(count, dist, time);
                break;
            }
            case 14: {
                float time;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IFfs", (Object[])args);
                if (found < 0) break;
                int count = (Integer)args[0];
                float dist = ((Float)args[1]).floatValue();
                float f = time = (found & 4) != 0 ? ((Float)args[2]).floatValue() : this.config.getMoveTime();
                if ((found & 8) != 0) {
                    this.hallName = String.valueOf((String)args[3]) + "_";
                }
                this.hallTest(count, dist, time, this.hallName);
                break;
            }
            case 17: {
                int nSamp;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IFfis", (Object[])args);
                if (found < 0) break;
                int count = (Integer)args[0];
                float dist = ((Float)args[1]).floatValue();
                float time = (found & 4) != 0 ? ((Float)args[2]).floatValue() : this.config.getMoveTime();
                int n = nSamp = (found & 8) != 0 ? ((Integer)args[3]).intValue() : this.config.getNumSamp();
                if ((found & 0x10) != 0) {
                    this.encName = String.valueOf((String)args[4]) + "_";
                }
                this.encTest(count, dist, time, nSamp, this.encName);
                break;
            }
            case 1: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IIf", (Object[])args);
                if (found < 0) break;
                int count = (Integer)args[0];
                int step = (Integer)args[1];
                float time = (found & 4) != 0 ? ((Float)args[2]).floatValue() : 0.1f;
                this.step(count, step, time);
                break;
            }
            case 2: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"if", (Object[])args);
                if (found < 0) break;
                int optns = (found & 1) != 0 ? (Integer)args[0] : 0;
                float vel = (found & 2) != 0 ? ((Float)args[1]).floatValue() : 10.0f;
                this.blade.home(optns, vel);
                break;
            }
            case 9: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Fiif", (Object[])args);
                if (found < 0) break;
                float freq = ((Float)args[0]).floatValue();
                if (freq != 0.0f) {
                    float fract;
                    Pulse pulse = new Pulse();
                    pulse.oLine = (found & 2) != 0 ? (Integer)args[1] : this.dioOLine;
                    pulse.mCount = (found & 4) != 0 ? (Integer)args[2] : -1;
                    float f = fract = (found & 8) != 0 ? ((Float)args[3]).floatValue() : 0.5f;
                    if (freq < 2.0f) {
                        freq = 2.0f;
                    }
                    if (freq > 10000.0f) {
                        freq = 10000.0f;
                    }
                    if (fract > 1.0f) {
                        fract = 1.0f;
                    }
                    pulse.width = fract / freq;
                    if (pulse.width < 1.0E-5f) {
                        pulse.width = 1.0E-5f;
                    }
                    pulse.count = 0;
                    this.hel.cntrConfig(freq, false);
                    this.hel.cntrEnable((Object)this, "genPulse", (Object)pulse);
                    this.hel.cntrStart();
                    break;
                }
                this.hel.cntrStop();
                this.hel.cntrDisable();
                break;
            }
            case 13: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ii", (Object[])args);
                if (found < 0) break;
                this.timeSync((found & 1) != 0 ? (Integer)args[0] != 0 : false, (found & 2) != 0 ? (Integer)args[1] : 10);
                break;
            }
            case 20: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args) < 0) break;
                this.showTemps();
                break;
            }
            case 12: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args) < 0) break;
                Thread[] threads = new Thread[Thread.activeCount()];
                int nThread = Thread.enumerate(threads);
                this.out.println((Object)"Thread information:");
                int j = 0;
                while (j < nThread) {
                    this.out.println((Object)("  " + threads[j]));
                    ++j;
                }
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    private void showConfig() {
        this.out.format("Blade %s Configuration:\n", new Object[]{this.config.getIndex()});
        this.out.format("  Controller node:             %s\n", new Object[]{this.config.getNode()});
        this.out.format("  Encoder pulses/mm:           %s\n", new Object[]{Float.valueOf(this.config.getPpMm())});
        this.out.format("  Blade home position (mm):    %s\n", new Object[]{Float.valueOf(this.config.getHome())});
        this.out.format("  Blade open position (mm):    %s\n", new Object[]{Float.valueOf(this.config.getOpen())});
        this.out.format("  Blade closed position (mm):  %s\n", new Object[]{Float.valueOf(this.config.getClosed())});
        this.out.format("  Position sample count:       %s\n", new Object[]{this.config.getNumSamp()});
        this.out.format("  Blade movement time (sec):   %s\n", new Object[]{Float.valueOf(this.config.getMoveTime())});
        this.out.format("  DIO board base address:      0x%04x\n", new Object[]{this.config.getDioAddr()});
        this.out.format("  DIO board IRQ level:         %s\n", new Object[]{this.config.getDioLevel()});
        this.out.format("  DIO board configuration:     0x%02x\n", new Object[]{this.config.getDioConf()});
        this.out.format("  Hall sensor DIO port:        %s\n", new Object[]{this.config.getDioHPort()});
        this.out.format("  Motor output DIO port:       %s\n", new Object[]{this.config.getDioOPort()});
        this.out.format("  Motor output DIO line:       %s\n", new Object[]{this.config.getDioOLine()});
        this.out.format("  Motor input DIO port:        %s\n", new Object[]{this.config.getDioIPort()});
        this.out.format("  Motor input DIO line:        %s\n", new Object[]{this.config.getDioILine()});
        this.out.format("  AD board base address:       0x%04x\n", new Object[]{this.config.getAdAddr()});
        this.out.format("  AD board IRQ level:          %s\n", new Object[]{this.config.getAdLevel()});
        this.out.format("  Temperature AD channel:      %s\n", new Object[]{this.config.getAdTempChn()});
    }

    private void calibrate(float dist, float step, float time, String file) {
        BladeSetCalibration calData = this.blade.calibrate(dist, step, time);
        this.showStop(calData.getStatus());
        BladeSetConfigurationDrvr.writeCalibration(calData, file);
        this.out.println((Object)("File " + file + " created"));
    }

    private void calTest(float dist, float time, String file) {
        BladeSetCalibration calData = this.blade.calibNew(dist, time);
        this.showStop(calData.getStatus());
        BladeSetConfigurationDrvr.writeCalibration(calData, file);
        this.out.println((Object)("File " + file + " created"));
    }

    private void calTest1(boolean useCapt, float dist, float time, String file) {
        int sTime;
        PrintStream ofl;
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        int mCount = 64;
        float freq = (float)mCount / (2.0f * time);
        Pulse pulse = new Pulse();
        pulse.mCount = 2 * mCount;
        pulse.width = 0.5f / freq;
        pulse.oLine = this.dioOLine;
        this.acd.dioClrBit(this.dioOPort, pulse.oLine);
        this.acr.sendStr("prog2", 0);
        this.acr.sendStr("new prog2", 0);
        this.acr.sendStr("program", 0);
        this.acr.sendStr("clear", 0);
        this.acr.sendStr("dim lv(10)", 0);
        this.acr.sendStr("dim la(5)", 0);
        this.acr.sendStr("dim la0(100)", 0);
        this.acr.sendStr("dim la1(100)", 0);
        this.acr.sendStr("dim la2(100)", 0);
        this.acr.sendStr("dim la3(100)", 0);
        this.acr.sendStr("dim la4(100)", 0);
        this.acr.sendStr("lv1 = 0", 0);
        this.acr.sendStr("set 129", 0);
        this.acr.sendStr("lv2 = p6916", 0);
        this.acr.sendStr("for lv0 = 0 to " + (mCount - 1) + " step 1", 0);
        this.acr.sendStr("if (lv1 = 0)", 0);
        this.acr.sendStr("intcap axis0 10", 0);
        if (useCapt) {
            this.acr.sendStr("inh 777", 0);
        } else {
            this.acr.sendStr("inh 4", 0);
        }
        this.acr.sendStr("else", 0);
        this.acr.sendStr("intcap axis0 14", 0);
        if (useCapt) {
            this.acr.sendStr("inh 777", 0);
        } else {
            this.acr.sendStr("inh -4", 0);
        }
        this.acr.sendStr("endif", 0);
        this.acr.sendStr("la0(lv0) = p6916", 0);
        this.acr.sendStr("la3(lv0) = p6144", 0);
        this.acr.sendStr("la1(lv0) = p4096", 0);
        this.acr.sendStr("la2(lv0) = p4120", 0);
        this.acr.sendStr("la4(lv0) = p12292", 0);
        this.acr.sendStr("lv1 = 1 - lv1", 0);
        this.acr.sendStr("next", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("endp", 0);
        this.hel.cntrConfig(freq, false);
        this.hel.cntrEnable((Object)this, "genPulse", (Object)pulse);
        this.acr.sendStr("sys", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("run prog2", 0);
        this.acr.sendStr("inh 129", 0);
        this.hel.cntrStart();
        if (dist != 0.0f) {
            this.blade.move(0, dist, time, 0.0f);
        } else {
            this.sleep(time);
        }
        this.acr.sendStr("inh -129", 0);
        this.acr.sendStr("intcap axis0 off", 0);
        this.hel.cntrStop();
        this.hel.cntrDisable();
        int[] vals = new int[3];
        this.acr.getVars(2, 0, 3, vals);
        int count = vals[0];
        int[] times = new int[count];
        int[] inpts = new int[count];
        int[] flags = new int[count];
        int[] posns = new int[count];
        int[] capts = new int[count];
        this.acr.getVars(2, 0, 0, count, times);
        this.acr.getVars(2, 1, 0, count, inpts);
        this.acr.getVars(2, 2, 0, count, flags);
        this.acr.getVars(2, 3, 0, count, posns);
        this.acr.getVars(2, 4, 0, count, capts);
        this.out.format("Capture count = %s, pulse count = %s\n", new Object[]{count, 2 * pulse.count});
        int pTime = sTime = vals[2];
        int j = 0;
        while (j < count) {
            ofl.format("%5s %5s %1s %1s %8.2f %6s %8.2f %6s\n", times[j] - sTime, times[j] - pTime, inpts[j] >> 4 & 1, flags[j] >> 9 & 1, Float.valueOf(this.config.position(posns[j])), posns[j], Float.valueOf(this.config.position(capts[j])), capts[j]);
            pTime = times[j];
            ++j;
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void calTest2(float dist, float time, String file) {
        PrintStream ofl;
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        int outLine = 33;
        this.acr.clearBit(outLine);
        int capMode = 10;
        Pulse pulse = new Pulse();
        pulse.mCount = 32;
        pulse.iLine = this.dioILine;
        pulse.oLine = this.dioOLine;
        pulse.width = time / (float)(2 * pulse.mCount);
        pulse.iState = this.acd.dioInpBit(this.dioIPort, pulse.iLine);
        this.acd.dioClrBit(this.dioOPort, pulse.oLine);
        this.acd.attachInt(1 << this.dioIPort, (Object)this, "passDio", (Object)pulse);
        this.acr.sendStr("prog2", 0);
        this.acr.sendStr("new prog2", 0);
        this.acr.sendStr("program", 0);
        this.acr.sendStr("clear", 0);
        this.acr.sendStr("dim lv(10)", 0);
        this.acr.sendStr("dim la(2)", 0);
        this.acr.sendStr("dim la0(100)", 0);
        this.acr.sendStr("dim la1(100)", 0);
        this.acr.sendStr("lv1 = " + capMode, 0);
        this.acr.sendStr("set 129", 0);
        this.acr.sendStr("lv2 = p6916", 0);
        this.acr.sendStr("for lv0 = 0 to " + (2 * pulse.mCount - 1) + " step 1", 0);
        this.acr.sendStr("intcap axis0 (lv1)", 0);
        this.acr.sendStr("if (lv1 = " + capMode + ") then set " + outLine, 0);
        this.acr.sendStr("if (lv1 <> " + capMode + ") then clr " + outLine, 0);
        this.acr.sendStr("inh 777", 0);
        this.acr.sendStr("la1(lv0) = p6916", 0);
        this.acr.sendStr("la0(lv0) = p12292", 0);
        this.acr.sendStr("lv1 = 24 - lv1", 0);
        this.acr.sendStr("dwl " + pulse.width, 0);
        this.acr.sendStr("next", 0);
        this.acr.sendStr("endp", 0);
        this.acr.sendStr("sys", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("run prog2", 0);
        this.acr.sendStr("inh 129", 0);
        if (dist != 0.0f) {
            this.blade.move(0, dist, time, 0.0f);
        } else {
            this.sleep(time);
        }
        this.acr.sendStr("halt prog2", 0);
        this.acr.sendStr("intcap axis0 off", 0);
        this.acd.detachInt();
        int[] vals = new int[3];
        this.acr.getVars(2, 0, 3, vals);
        int count = vals[0];
        int[] posns = new int[count];
        int[] times = new int[count];
        this.acr.getVars(2, 0, 0, count, posns);
        this.acr.getVars(2, 1, 0, count, times);
        this.out.format("Capture count = %s, transition count = %s (%s)\n", new Object[]{count, pulse.count, count == pulse.count ? "ok" : "mismatch"});
        int pTime = vals[2];
        int j = 0;
        while (j < count) {
            ofl.format("%5s %5s %8.2f %6s\n", times[j] - vals[2], times[j] - pTime, Float.valueOf(this.config.position(posns[j])), posns[j]);
            pTime = times[j];
            ++j;
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void calTest4(float dist, float time, String file) {
        PrintStream ofl;
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        int outLine = 33;
        this.acr.clearBit(outLine);
        Pulse pulse = new Pulse();
        pulse.mCount = 32;
        pulse.iLine = this.dioILine;
        pulse.oLine = this.dioOLine;
        pulse.width = time / (float)(2 * pulse.mCount);
        pulse.iState = this.acd.dioInpBit(this.dioIPort, pulse.iLine);
        this.acd.dioClrBit(this.dioOPort, pulse.oLine);
        this.acd.attachInt(1 << this.dioIPort, (Object)this, "passDio", (Object)pulse);
        float delay = 0.009f;
        float ohead = 0.005f;
        this.acr.sendStr("prog2", 0);
        this.acr.sendStr("new prog2", 0);
        this.acr.sendStr("program", 0);
        this.acr.sendStr("clear", 0);
        this.acr.sendStr("dim lv(10)", 0);
        this.acr.sendStr("dim la(2)", 0);
        this.acr.sendStr("dim la0(100)", 0);
        this.acr.sendStr("dim la1(100)", 0);
        this.acr.sendStr("lv1 = 0", 0);
        this.acr.sendStr("set 129", 0);
        this.acr.sendStr("lv2 = p6916", 0);
        this.acr.sendStr("for lv0 = 0 to " + (2 * pulse.mCount - 1) + " step 1", 0);
        this.acr.sendStr("if (lv1 = 0) then set " + outLine, 0);
        this.acr.sendStr("if (lv1 <> 0) then clr " + outLine, 0);
        this.acr.sendStr("dwl " + delay, 0);
        this.acr.sendStr("la1(lv0) = p6916", 0);
        this.acr.sendStr("la0(lv0) = p4096", 0);
        this.acr.sendStr("lv1 = 1 - lv1", 0);
        this.acr.sendStr("dwl " + (pulse.width - delay - ohead), 0);
        this.acr.sendStr("next", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("endp", 0);
        this.acr.sendStr("sys", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("run prog2", 0);
        this.acr.sendStr("inh 129", 0);
        if (dist != 0.0f) {
            this.blade.move(0, dist, time, 0.0f);
        } else {
            this.sleep(time);
        }
        this.acr.sendStr("inh -129", 0);
        this.acd.detachInt();
        int[] vals = new int[3];
        this.acr.getVars(2, 0, 3, vals);
        int count = vals[0];
        int[] inpts = new int[count];
        int[] times = new int[count];
        this.acr.getVars(2, 0, 0, count, inpts);
        this.acr.getVars(2, 1, 0, count, times);
        this.out.format("Capture count = %s, transition count = %s (%s)\n", new Object[]{count, pulse.count, count == pulse.count ? "ok" : "mismatch"});
        int pTime = vals[2];
        int j = 0;
        while (j < count) {
            ofl.format("%5s %5s %08x\n", times[j] - vals[2], times[j] - pTime, inpts[j]);
            pTime = times[j];
            ++j;
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void showCalib() {
        ArrayList<BladeSetCalibration.Item> cList = this.config.getCalibration().getData();
        this.out.println((Object)"Dirn   Swtch   Index   Action   Position");
        this.out.println((Object)"----   -----   -----   ------   --------");
        int j = 0;
        while (j < cList.size()) {
            BladeSetCalibration.Item data = cList.get(j);
            this.out.format("%4s   %5s   %5s   %6s   %8.2f\n", new Object[]{data.isReverse() ? "Back" : "Forw", data.getSensor(), data.getIndex(), data.isOpen() ? "Open " : "Close", Float.valueOf(data.getPosition())});
            ++j;
        }
    }

    private void position(float relPosn, float time, String name) {
        long tStamp = System.currentTimeMillis();
        String fileH = this.genFileName(name, "_H.dat", tStamp);
        String fileP = this.genFileName(name, "_P.dat", tStamp);
        PrintStream oflH = null;
        PrintStream oflP = null;
        try {
            oflH = new PrintStream(fileH);
            oflP = new PrintStream(fileP);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            if (oflH != null) {
                oflH.close();
            }
            if (oflP != null) {
                oflP.close();
            }
            return;
        }
        this.showMoveStart();
        this.blade.moveToPosition(relPosn, time);
        this.showMoveEnd();
        this.showStop(this.mhData.getStatus());
        if (this.mhData == null) {
            oflH.close();
            oflP.close();
            return;
        }
        this.writePosnData(this.mhData, oflP);
        this.writeHallData(this.mhData, oflH);
        oflH.close();
        oflP.close();
        this.out.println((Object)("Files " + fileH + " and " + fileP + " created"));
    }

    @Override
    public void movementHistoryFinalized(MovementHistory mh) {
        this.mhData = mh;
    }

    @Override
    public void movementHistoryUpdated(MovementHistory mh) {
    }

    private void move(int type, float dist, float time, float mvFract) {
        this.showMoveStart();
        int status = this.blade.move(type, dist, time, mvFract);
        this.showMoveEnd();
        this.showStop(status);
    }

    private void moveD(int type, float dist, float time, float mvFract, int nSamp, String name) {
        PrintStream ofl;
        String file = this.genFileName(name, "_D.dat");
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        int[] iParms = new int[]{6916, 6144, 4120};
        int[] fParms = new int[]{28738, 28739, 28740, 28745};
        this.showMoveStart();
        BladeSetDrvr.SampData data = this.blade.moveD(type, dist, time, mvFract, nSamp, iParms, fParms);
        this.showMoveEnd();
        this.showStop(data.status);
        if (data == null) {
            ofl.close();
            return;
        }
        int j = 0;
        while (j < data.sList.size()) {
            BladeSetDrvr.Sample samp = data.sList.get(j);
            ofl.format("%12s %5s %8.2f %12s %12s %12s %12s %08x\n", data.startTime + (long)(samp.time / 1000), samp.time / 1000, Float.valueOf(this.config.position(samp.iVals[1])), Float.valueOf(samp.fVals[0]), Float.valueOf(samp.fVals[1]), Float.valueOf(samp.fVals[2]), Float.valueOf(samp.fVals[3]), samp.iVals[2]);
            if ((samp.iVals[2] & 0x1000000) == 0) break;
            ++j;
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void moveH(int type, float dist, float time, float mvFract, int nSamp, String name) {
        long tStamp = System.currentTimeMillis();
        String fileH = this.genFileName(name, "_H.dat", tStamp);
        String fileP = this.genFileName(name, "_P.dat", tStamp);
        PrintStream oflH = null;
        PrintStream oflP = null;
        try {
            oflH = new PrintStream(fileH);
            oflP = new PrintStream(fileP);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            if (oflH != null) {
                oflH.close();
            }
            if (oflP != null) {
                oflP.close();
            }
            return;
        }
        this.showMoveStart();
        MovementHistory data = this.blade.moveH(type, dist, time, mvFract, nSamp);
        this.showMoveEnd();
        this.showStop(data.getStatus());
        if (data == null) {
            oflH.close();
            oflP.close();
            return;
        }
        this.writePosnData(data, oflP);
        this.writeHallData(data, oflH);
        oflH.close();
        oflP.close();
        this.out.println((Object)("Files " + fileH + " and " + fileP + " created"));
    }

    private void moveP(int type, float dist, float time, float mvFract, int nSamp, String name) {
        PrintStream ofl;
        String file = this.genFileName(name, "_P.dat");
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        this.showMoveStart();
        MovementHistory data = this.blade.moveP(type, dist, time, mvFract, nSamp);
        this.showMoveEnd(data.getEndPosition(), data.getEndTime() / 1000L);
        this.showStop(data.getStatus());
        if (data == null) {
            ofl.close();
            return;
        }
        this.writePosnData(data, ofl);
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void moveX(int type, float dist, float time, float mvFract, int nSamp, String name) {
        PrintStream ofl;
        String file = this.genFileName(name, "_X.dat");
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        int[] iParms = new int[]{6144, 4096};
        int[] fParms = new int[]{};
        this.showMoveStart();
        BladeSetDrvr.SampData data = this.blade.moveD(type, dist, time, mvFract, nSamp, iParms, fParms);
        this.showMoveEnd();
        this.showStop(data.status);
        if (data == null) {
            ofl.close();
            return;
        }
        int j = 0;
        while (j < data.sList.size()) {
            BladeSetDrvr.Sample samp = data.sList.get(j);
            ofl.format("%8.2f %08x\n", Float.valueOf(this.config.position(samp.iVals[0])), samp.iVals[1]);
            ++j;
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void moveTest(int count, float dist, float time) {
        if (dist < 0.0f) {
            dist = -dist;
        }
        if (dist == 0.0f) {
            dist = 10.0f;
        }
        this.showMoveStart();
        int status = 0;
        int si = 0;
        while (si < count) {
            status = this.blade.move(0, dist, time, 0.0f);
            if (status != 0 || (status = this.blade.move(0, -dist, time, 0.0f)) != 0) break;
            ++si;
        }
        this.showMoveEnd();
        if (status != 0) {
            this.out.format("%s after %s cycles\n", new Object[]{this.getStop(status), si});
        } else {
            this.out.format("%s cycles completed successfully\n", new Object[]{si});
        }
    }

    private void hallTest(int count, float dist, float time, String name) {
        PrintStream ofl;
        ArrayList<BladeSetCalibration.Item> cList = this.config.getCalibration().getData();
        String file = this.genFileName(name, ".dat");
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        if (count <= 0) {
            count = 1;
        }
        int[][] times = new int[cList.size()][count];
        if (dist < 0.0f) {
            dist = -dist;
        }
        int type = 0;
        float mxvf = 0.0f;
        int nSamp = this.config.getNumSamp();
        float posn = this.blade.getPosition();
        if (posn > 1.0f || posn < -1.0f) {
            this.blade.move(type, -posn, 1.0f, mxvf);
        }
        int si = 0;
        while (si < count) {
            int sensor;
            boolean open;
            BladeSetCalibration.Item cItem;
            HallTransition hItem;
            MovementHistory data1;
            this.blade.move(type, -10.0f, 1.0f, mxvf);
            this.blade.home(0, 10.0f);
            MovementHistory data0 = this.blade.moveH(type, -dist, time, mxvf, nSamp);
            if (data0 == null || (data1 = this.blade.moveH(type, dist, time, mxvf, nSamp)) == null) break;
            int ci = 0;
            List<HallTransition> hList = data0.getHallTransitions();
            long sTime = data0.getStartTime();
            int j = 0;
            while (j < hList.size()) {
                hItem = hList.get(j);
                cItem = cList.get(ci);
                open = hItem.isOpen();
                sensor = hItem.getSensorId();
                if (!cItem.isReverse() || cItem.getSensor() != sensor || cItem.isOpen() != open) {
                    this.out.format("Inconsistent data: %s true %s %s %s %s, index = %s, cycle = %s\n", new Object[]{cItem.isReverse(), cItem.getSensor(), sensor, cItem.isOpen(), open, ci, si});
                } else {
                    times[ci++][si] = (int)((hItem.getTransitionTime() - sTime + 50L) / 100L);
                }
                ++j;
            }
            hList = data1.getHallTransitions();
            sTime = data1.getStartTime();
            j = 0;
            while (j < hList.size()) {
                hItem = hList.get(j);
                cItem = cList.get(ci);
                open = hItem.isOpen();
                sensor = hItem.getSensorId();
                if (cItem.isReverse() || cItem.getSensor() != sensor || cItem.isOpen() != open) {
                    this.out.format("Inconsistent data: %s false %s %s %s %s, index = %s, cycle = %s\n", new Object[]{cItem.isReverse(), cItem.getSensor(), sensor, cItem.isOpen(), open, ci, si});
                } else {
                    times[ci++][si] = (int)((hItem.getTransitionTime() - sTime + 50L) / 100L);
                }
                ++j;
            }
            ++si;
        }
        int ci = 0;
        while (ci < cList.size()) {
            BladeSetCalibration.Item cItem = cList.get(ci);
            ofl.format("%s %s %s %8.2f", cItem.getSensor(), cItem.isOpen() ? "O" : "C", cItem.isReverse() ? "-" : "+", Float.valueOf(cItem.getPosition()));
            int si2 = 0;
            while (si2 < count) {
                ofl.format(" %5s", times[ci][si2]);
                ++si2;
            }
            ofl.println();
            ++ci;
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void encTest(int count, float dist, float time, int nSamp, String name) {
        PrintStream ofl;
        String file = this.genFileName(name, ".dat");
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        if (count <= 0) {
            count = 1;
        }
        int[][] times = new int[2 * nSamp][count];
        float[][] posns = new float[2 * nSamp][count];
        if (dist < 0.0f) {
            dist = -dist;
        }
        int type = 0;
        float mxvf = 0.0f;
        float posn = this.blade.getPosition();
        if (posn > 1.0f || posn < -1.0f) {
            this.blade.move(type, -posn, 1.0f, mxvf);
        }
        int si = 0;
        while (si < count) {
            BladePosition pItem;
            MovementHistory data1;
            MovementHistory data0 = this.blade.moveP(type, -dist, time, mxvf, nSamp);
            if (data0 == null || (data1 = this.blade.moveP(type, dist, time, mxvf, nSamp)) == null) break;
            int ci = 0;
            List<BladePosition> pList = data0.getMovementProfile();
            long sTime = data0.getStartTime();
            int size = pList.size();
            BladePositionImpl pDummy = new BladePositionImpl(-1.0f, -1.0f);
            int j = 0;
            while (j < nSamp) {
                pItem = j >= size ? pDummy : pList.get(j);
                times[ci][si] = (int)((pItem.getTime() - sTime + 50L) / 100L);
                posns[ci++][si] = pItem.getPosition();
                ++j;
            }
            pList = data1.getMovementProfile();
            sTime = data1.getStartTime();
            size = pList.size();
            j = 0;
            while (j < nSamp) {
                pItem = j >= size ? pDummy : pList.get(j);
                times[ci][si] = (int)((pItem.getTime() - sTime + 50L) / 100L);
                posns[ci++][si] = pItem.getPosition();
                ++j;
            }
            ++si;
        }
        int ci = 0;
        while (ci < 2 * nSamp) {
            ofl.format("%s", ci < nSamp ? "-" : "+");
            int si2 = 0;
            while (si2 < count) {
                ofl.format(" %5s %8.2f", times[ci][si2], Float.valueOf(posns[ci][si2]));
                ++si2;
            }
            ofl.println();
            ++ci;
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void step(int count, int step, float time) {
        int fPosn;
        float vel = Math.abs(2.0f * (float)step / time);
        float acc = Math.abs(8.0f * (float)step / (time * time));
        float jrk = acc * acc / vel;
        this.acr.setFloatParm(12375, 1.0f);
        this.acr.setFloatParm(12348, vel);
        this.acr.setFloatParm(12349, acc);
        this.acr.setFloatParm(12350, acc);
        this.acr.setFloatParm(12351, jrk);
        this.acr.sendStr("axis0 slm (" + this.config.posSoftLimit() * this.config.ppu() + "," + this.config.negSoftLimit() * this.config.ppu() + ")", 0);
        this.blade.enableDrive();
        int minm = Integer.MAX_VALUE;
        int maxm = Integer.MIN_VALUE;
        int sumSq = 0;
        int pPosn = fPosn = this.acr.getIntParm(6144);
        int nStep = 0;
        while (nStep < count) {
            this.acr.sendStr("axis0 jog inc " + step, 0);
            this.acr.sendStr("inh -792", 0);
            if (this.showStop() != null) break;
            int cPosn = this.acr.getIntParm(6144);
            int cStep = cPosn - pPosn;
            if (cStep > maxm) {
                maxm = cStep;
            }
            if (cStep < minm) {
                minm = cStep;
            }
            sumSq += cStep * cStep;
            pPosn = cPosn;
            ++nStep;
        }
        double avg = (double)(pPosn - fPosn) / (double)(nStep == 0 ? 1 : nStep);
        double var = (double)sumSq / (double)(nStep == 0 ? 1 : nStep) - avg * avg;
        this.out.format("Steps = %s, counts = %s, min = %s, max = %s, avg = %.2f, sigma = %.4f\n", new Object[]{nStep, pPosn - fPosn, minm == Integer.MAX_VALUE ? 0 : minm, maxm == Integer.MIN_VALUE ? 0 : maxm, avg, Math.sqrt(var)});
        this.acr.setFloatParm(12375, this.config.ppu());
        this.acr.sendStr("axis0 slm (" + this.config.posSoftLimit() + "," + this.config.negSoftLimit() + ")", 0);
        this.blade.disableDrive();
    }

    private void timeSync(boolean useCapt, int count) {
        this.acr.clearBit(33);
        this.acd.dioClrBit(this.dioOPort, this.dioOLine);
        BladeSetDrvr.Hall hall = new BladeSetDrvr.Hall(2 * count);
        hall.state = this.acd.dioInpBit(this.dioIPort, this.dioILine);
        this.acd.attachInt(1 << this.dioIPort, (Object)this, "readACR", (Object)hall);
        if ((count & 1) != 0) {
            ++count;
        }
        this.acr.sendStr("prog2", 0);
        this.acr.sendStr("new prog2", 0);
        this.acr.sendStr("program", 0);
        this.acr.sendStr("clear", 0);
        this.acr.sendStr("dim lv(10)", 0);
        this.acr.sendStr("dim la(1)", 0);
        this.acr.sendStr("dim la0(" + count + ")", 0);
        this.acr.sendStr("lv0 = 0", 0);
        this.acr.sendStr("set 129", 0);
        this.acr.sendStr("while (lv0 < " + count + ")", 0);
        this.acr.sendStr("intcap axis0 10", 0);
        this.acr.sendStr("set 33", 0);
        if (useCapt) {
            this.acr.sendStr("inh 777", 0);
        } else {
            this.acr.sendStr("inh 4", 0);
        }
        this.acr.sendStr("la0(lv0) = p6916", 0);
        this.acr.sendStr("lv0 = lv0 + 1", 0);
        this.acr.sendStr("intcap axis0 14", 0);
        this.acr.sendStr("clr 33", 0);
        if (useCapt) {
            this.acr.sendStr("inh 777", 0);
        } else {
            this.acr.sendStr("inh -4", 0);
        }
        this.acr.sendStr("la0(lv0) = p6916", 0);
        this.acr.sendStr("lv0 = lv0 + 1", 0);
        this.acr.sendStr("wend", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("endp", 0);
        this.acr.sendStr("sys", 0);
        this.acr.clearBit(129);
        this.acr.sendStr("run prog2", 0);
        this.acr.sendStr("inh 129", 0);
        this.acr.sendStr("inh -129", 0);
        this.acd.detachInt();
        int[] vals = new int[1];
        this.acr.getVars(2, 0, 1, vals);
        int cCount = vals[0];
        int[] times = new int[cCount];
        this.acr.getVars(2, 0, 0, vals[0], times);
        this.out.format("Counts: requested = %s, controller = %s, computer = %s\n", new Object[]{count, cCount, hall.count});
        int pCTime = times[0];
        long pHTime = hall.data[0].time;
        count = cCount > hall.count ? cCount : hall.count;
        int j = 0;
        while (j < count) {
            if (j < cCount) {
                this.out.format("%4s", new Object[]{times[j] - pCTime});
                pCTime = times[j];
            } else {
                this.out.format("    ", new Object[0]);
            }
            if (j < hall.count) {
                BladeSetDrvr.HallItem item = hall.data[j];
                long hTime = item.time;
                this.out.format("  %4s  %s", new Object[]{(hTime - pHTime) / 1000000L, item.open ? "O" : "C"});
                pHTime = hTime;
            }
            this.out.println();
            ++j;
        }
    }

    private void showTemps() {
        this.out.format("Drive temperature: %.2f, Ambient temperature: %.2f\n", new Object[]{Float.valueOf(this.blade.getDriveTemperature()), Float.valueOf(this.blade.getAmbientTemperature())});
    }

    private void writePosnData(MovementHistory data, PrintStream ofl) {
        long sTime = data.getStartTime() / 1000L;
        List<BladePosition> pList = data.getMovementProfile();
        int j = 0;
        while (j < pList.size()) {
            BladePosition pItem = pList.get(j);
            long pTime = pItem.getTime() / 1000L;
            ofl.format("%12s %5s %8.2f %8.5f\n", pTime, pTime - sTime, Float.valueOf(pItem.getPosition()), Float.valueOf(pItem.getRelPosition()));
            ++j;
        }
    }

    private void writeHallData(MovementHistory data, PrintStream ofl) {
        long sTime = data.getStartTime() / 1000L;
        List<HallTransition> hList = data.getHallTransitions();
        int j = 0;
        while (j < hList.size()) {
            HallTransition hItem = hList.get(j);
            long hTime = (hItem.getTransitionTime() + 500L) / 1000L;
            ofl.format("%12s %5s %s %s %s %8.2f %8.5f\n", hTime, hTime - sTime, hItem.getSensorId(), hItem.isOpen() ? "O" : "C", hItem.isReverse() ? "-" : "+", Float.valueOf(hItem.getPosition()), Float.valueOf(hItem.getRelPosition()));
            ++j;
        }
    }

    private String genFileName(String head, String tail, long tStamp) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(tStamp);
        return String.valueOf(head) + this.bladeIndex + "_" + String.format("%tY%<tm%<td_%<tH%<tM%<tS", cal) + tail;
    }

    private String genFileName(String head, String tail) {
        return this.genFileName(head, tail, System.currentTimeMillis());
    }

    private void showMoveStart(float posn, long time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(time);
        this.out.format("Started move: posn = %8.2f, time = %tF %<tT.%<tL\n", new Object[]{Float.valueOf(posn), cal});
    }

    private void showMoveStart() {
        this.showMoveStart(this.blade.getPosition(), System.currentTimeMillis());
    }

    private void showMoveEnd(float posn, long time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(time);
        this.out.format("Ended move  : posn = %8.2f, time = %tF %<tT.%<tL\n", new Object[]{Float.valueOf(posn), cal});
    }

    private void showMoveEnd() {
        this.showMoveEnd(this.blade.getPosition(), System.currentTimeMillis());
    }

    private void showPosition() {
        int posn = this.acr.getIntParm(6144);
        this.out.format("Position = %.2f mm (encoder = %s)\n", new Object[]{Float.valueOf(this.config.position(posn)), posn});
    }

    private void showRelPosition() {
        this.out.format("Relative position = %.5f\n", new Object[]{Float.valueOf(this.blade.getCurrentPosition())});
    }

    private String showStop(int status) {
        String stopped = this.getStop(status);
        if (stopped != null) {
            this.out.println((Object)stopped);
        }
        return stopped;
    }

    private String showStop() {
        return this.showStop(this.blade.moveStatus());
    }

    private String getStop(int status) {
        if (status == 0) {
            return null;
        }
        return MovementStatus.message(status);
    }

    private String getStop() {
        return this.getStop(this.blade.moveStatus());
    }

    private void genPulse(int value, Object parm) {
        Pulse pulse = (Pulse)parm;
        if (pulse.count >= pulse.mCount) {
            return;
        }
        this.acd.dioSetBit(this.dioOPort, pulse.oLine);
        this.sleep(pulse.width);
        this.acd.dioClrBit(this.dioOPort, pulse.oLine);
        ++pulse.count;
    }

    private void passDio(int value, Object parm) {
        Pulse pulse = (Pulse)parm;
        int state = this.acd.dioInpBit(this.dioIPort, pulse.iLine);
        if (state == pulse.iState) {
            return;
        }
        pulse.iState = state;
        ++pulse.count;
        if (state != 0) {
            this.acd.dioClrBit(this.dioOPort, pulse.oLine);
        } else {
            this.acd.dioSetBit(this.dioOPort, pulse.oLine);
        }
    }

    private void readACR(int value, Object parm) {
        boolean open;
        BladeSetDrvr.Hall hall = (BladeSetDrvr.Hall)parm;
        int state = this.acd.dioInpBit(this.dioIPort, this.dioILine);
        if (state == hall.state) {
            return;
        }
        hall.state = state;
        boolean bl = open = state != 0;
        if (!open) {
            this.acd.dioSetBit(this.dioOPort, this.dioOLine);
        } else {
            this.acd.dioClrBit(this.dioOPort, this.dioOLine);
        }
        if (hall.count >= hall.data.length) {
            return;
        }
        BladeSetDrvr.HallItem item = hall.data[hall.count++];
        item.time = System.nanoTime();
        item.open = open;
    }

    private void sleep(float secs) {
        long nsecs = (long)(1.0E9f * secs);
        try {
            Thread.sleep(nsecs / 1000000L, (int)(nsecs % 1000000L));
        }
        catch (InterruptedException interruptedException) {}
    }

    public static class Pulse {
        int mCount;
        int count;
        int oLine;
        int iLine;
        int iState;
        float width;
    }
}

