/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.driver;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.drivers.iocard.AccesDio;
import org.lsst.ccs.drivers.iocard.Helios;
import org.lsst.ccs.drivers.parker.AcrComm;
import org.lsst.ccs.subsystems.shutter.common.BladePositionImpl;
import org.lsst.ccs.subsystems.shutter.common.HallTransitionImpl;
import org.lsst.ccs.subsystems.shutter.common.MovementHistoryImpl;
import org.lsst.ccs.subsystems.shutter.driver.BladeSetCalibration;
import org.lsst.ccs.subsystems.shutter.driver.BladeSetConfigurationDrvr;
import org.lsst.ccs.subsystems.shutter.interfaces.BladePosition;
import org.lsst.ccs.subsystems.shutter.interfaces.BladeSet;
import org.lsst.ccs.subsystems.shutter.interfaces.HallSensorListener;
import org.lsst.ccs.subsystems.shutter.interfaces.HallTransition;
import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistory;
import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistoryListener;

public class BladeSetDrvr
implements BladeSet {
    public static final int MOV_TYP_SCURVE = 0;
    public static final int MOV_TYP_TRAP = 1;
    public static final int HOM_OPT_NDIRN = 1;
    public static final int HOM_OPT_PFINAL = 2;
    public static final float TORQUE_LIM = 10.0f;
    private static final int P_DRVON = 0;
    private static final int P_DIST = 1;
    private static final int P_SMPTM = 2;
    private static final int P_SMPCT = 3;
    private static final int P_NIPRM = 4;
    private static final int P_NFPRM = 5;
    private static final int P_PARMS = 6;
    private static final int MOVE_PROG = 0;
    private static final int CAL_PROG = 1;
    private static final int TEST_PROG = 2;
    private static final int TEMP_PROG = 3;
    private BladeSetConfigurationDrvr config = new BladeSetConfigurationDrvr();
    private BladeSetCalibration calData;
    private ArrayList<HallSensorListener> hsListeners = new ArrayList();
    private ArrayList<MovementHistoryListener> mhListeners = new ArrayList();
    private int bladeIndex;
    private int dioHPort;
    private int dioIPort;
    private int dioILine;
    private int dioOPort;
    private int dioOLine;
    private boolean driveOn = false;
    private AccesDio acd;
    private Helios hel;
    private AcrComm acr;

    @Override
    public void setIndex(int index) {
        this.config.setIndex(index);
        this.bladeIndex = index;
        this.dioHPort = this.config.getDioHPort();
        this.dioIPort = this.config.getDioIPort();
        this.dioILine = this.config.getDioILine();
        this.dioOPort = this.config.getDioOPort();
        this.dioOLine = this.config.getDioOLine();
        this.acr = new AcrComm(this.config.getNode(), true);
        this.acrInitialize();
        this.acd = new AccesDio();
        this.acd.init(this.config.getDioAddr(), this.config.getDioLevel());
        this.acd.dioConfig(this.config.getDioConf());
        this.hel = new Helios();
        this.hel.init(this.config.getAdAddr(), this.config.getAdLevel());
        this.hel.adConfig(3, true, false);
        this.hel.adSetChan(this.config.getAdTempChn());
    }

    @Override
    public int getIndex() {
        return this.bladeIndex;
    }

    @Override
    public void moveToPosition(float relPosition, float time) {
        MovementHistory history = this.moveH(0, this.config.position(relPosition) - this.getPosition(), time, 0.0f, this.config.getNumSamp());
        for (MovementHistoryListener l : this.mhListeners) {
            l.movementHistoryFinalized(history);
        }
    }

    @Override
    public float getCurrentPosition() {
        return this.config.relPosition(this.acr.getIntParm(6144));
    }

    @Override
    public BladeSetConfigurationDrvr getBladeSetConfiguration() {
        return this.config;
    }

    @Override
    public void addMovementHistoryListener(MovementHistoryListener l) {
        this.mhListeners.add(l);
    }

    @Override
    public void removeMovementHistoryListener(MovementHistoryListener l) {
        this.mhListeners.remove(l);
    }

    @Override
    public void addHallSensorListener(HallSensorListener l) {
        this.hsListeners.add(l);
    }

    @Override
    public void removeHallSensorListener(HallSensorListener l) {
        this.hsListeners.remove(l);
    }

    public float getPosition() {
        return this.config.position(this.acr.getIntParm(6144));
    }

    public void setDriveOn() {
        this.enableDrive();
        this.driveOn = true;
    }

    public void setDriveOff() {
        this.driveOn = false;
        this.disableDrive();
    }

    public void enableDrive() {
        if (!this.driveOn) {
            this.acr.sendStr("axis 0 drive on", 0);
        }
    }

    public void disableDrive() {
        if (!this.driveOn) {
            this.acr.sendStr("axis 0 drive off", 0);
        }
    }

    public BladeSetCalibration calibrate(float dist, float step, float time) {
        BladeSetCalibration calib = new BladeSetCalibration();
        dist = Math.copySign(dist, this.config.getClosed() - this.config.getOpen());
        this.calibLeg(dist, step, time, calib);
        this.calibLeg(-dist, step, time, calib);
        return calib;
    }

    public BladeSetCalibration calibNew(float dist, float time) {
        int capMode;
        BladeSetCalibration calib = new BladeSetCalibration();
        dist = Math.copySign(dist, this.config.getClosed() - this.config.getOpen());
        Hall hall = new Hall();
        hall.state = this.acd.dioInp(this.dioHPort);
        this.acd.attachInt(1 << this.dioHPort, (Object)this, "readHallC", (Object)hall);
        if (hall.state == 255) {
            this.acd.dioSetBit(this.dioOPort, this.dioOLine);
            capMode = 14;
        } else {
            this.acd.dioClrBit(this.dioOPort, this.dioOLine);
            capMode = 10;
        }
        this.acr.sendStr("prog1", 0);
        this.acr.sendStr("program", 0);
        this.acr.sendStr("clear", 0);
        this.acr.sendStr("dim lv(10)", 0);
        this.acr.sendStr("dim la(1)", 0);
        this.acr.sendStr("dim la0(100)", 0);
        this.acr.sendStr("lv0 = 0", 0);
        this.acr.sendStr("lv1 = " + capMode, 0);
        this.acr.sendStr("set 129", 0);
        this.acr.sendStr("while (1 = 1)", 0);
        this.acr.sendStr("intcap axis0 (lv1)", 0);
        this.acr.sendStr("inh 777", 0);
        this.acr.sendStr("la0(lv0) = p12292", 0);
        this.acr.sendStr("lv0 = lv0 + 1", 0);
        this.acr.sendStr("lv1 = 24 - lv1", 0);
        this.acr.sendStr("wend", 0);
        this.acr.sendStr("endp", 0);
        this.acr.sendStr("sys", 0);
        this.calibLegNew(dist, time, hall, calib);
        this.calibLegNew(-dist, time, hall, calib);
        this.acd.detachInt();
        this.acd.dioClrBit(this.dioOPort, this.dioOLine);
        return calib;
    }

    public void setCalib(BladeSetCalibration list) {
        this.calData = list;
    }

    public BladeSetCalibration getCalib() {
        return this.calData;
    }

    public int move(int type, float dist, float time, float mvFract) {
        if (dist == 0.0f) {
            return 0;
        }
        this.configMove(type, dist, time, mvFract);
        this.acr.sendStr("axis0 jog inc " + this.config.motorDistance(dist), 0);
        this.acr.sendStr("inh -792", 0);
        this.disableDrive();
        return this.moveStatus();
    }

    public SampData moveD(int type, float dist, float time, float mvFract, int nSamp, int[] iParms, int[] fParms) {
        int nsamp = this.initMove(type, dist, time, mvFract, nSamp, iParms, fParms);
        SampData data = new SampData();
        data.startPosn = this.getPosition();
        data.startTime = this.runMove(nsamp <= 0, null);
        data.endTime = System.currentTimeMillis();
        data.endPosn = this.getPosition();
        if (nsamp <= 0) {
            data.status = -nsamp;
            return data;
        }
        int[][] iVals = new int[iParms.length][nsamp];
        float[][] fVals = new float[fParms.length][nsamp];
        int[] time0 = new int[1];
        int tsamp = this.acr.getVars(0, 0, 1, time0);
        int j = 0;
        while (j < iParms.length) {
            tsamp += this.acr.getVars(0, j, 0, nsamp, iVals[j]);
            ++j;
        }
        j = 0;
        while (j < fParms.length) {
            tsamp += this.acr.getVars(0, j, 0, nsamp, fVals[j]);
            ++j;
        }
        if (tsamp != nsamp * (iParms.length + fParms.length) + 1) {
            data.status = 7;
            return data;
        }
        data.status = this.moveStatus();
        int tIndx = -1;
        int j2 = 0;
        while (j2 < iParms.length) {
            if (iParms[j2] == 6916) {
                tIndx = j2;
            }
            ++j2;
        }
        j2 = 0;
        while (j2 < nsamp) {
            Sample sItem = new Sample();
            sItem.time = 0;
            sItem.iVals = new int[iParms.length];
            int k = 0;
            while (k < iParms.length) {
                sItem.iVals[k] = iVals[k][j2];
                if (k == tIndx) {
                    int n = k;
                    sItem.iVals[n] = sItem.iVals[n] - time0[0];
                    sItem.time = 1000 * sItem.iVals[k];
                }
                ++k;
            }
            sItem.fVals = new float[fParms.length];
            k = 0;
            while (k < fParms.length) {
                sItem.fVals[k] = fVals[k][j2];
                ++k;
            }
            data.sList.add(sItem);
            ++j2;
        }
        return data;
    }

    public MovementHistory moveH(int type, float dist, float time, float mvFract, int nSamp) {
        Hall hall = new Hall();
        hall.state = this.acd.dioInp(this.dioHPort);
        this.acd.attachInt(1 << this.dioHPort, (Object)this, "readHallM", (Object)hall);
        int[] iParms = new int[]{6916, 6144, 4120};
        int[] fParms = new int[]{};
        int nsamp = this.initMove(type, dist, time, mvFract, nSamp, iParms, fParms);
        MovementHistoryImpl data = new MovementHistoryImpl();
        data.setBladeSetIndex(this.bladeIndex);
        data.setStartPosition(this.getPosition());
        long sTime = 1000L * this.runMove(nsamp <= 0, hall);
        data.setStartTime(sTime);
        data.setEndTime(1000L * System.currentTimeMillis());
        data.setEndPosition(this.getPosition());
        this.acd.detachInt();
        if (nsamp <= 0) {
            data.setStatus(-nsamp);
            return data;
        }
        List<BladePosition> pList = data.getMovementProfile();
        int status = this.getPositionData(sTime, nsamp, pList);
        if (status == 0) {
            status = this.moveStatus();
        }
        data.setStatus(status);
        float posn = pList.isEmpty() ? 0.0f : pList.get(0).getPosition();
        boolean reverse = dist < 0.0f;
        ArrayList<BladeSetCalibration.Item> cList = this.config.getCalibration().getData();
        int cIndex = 0;
        while (cIndex < cList.size()) {
            BladeSetCalibration.Item cItem = cList.get(cIndex);
            if (!(cItem.isReverse() ^ reverse) && (reverse && cItem.getPosition() < posn || !reverse && cItem.getPosition() > posn)) break;
            ++cIndex;
        }
        List<HallTransition> hList = data.getHallTransitions();
        if (hall.count > hall.data.length) {
            if (status == 0) {
                data.setStatus(8);
            }
            hall.count = hall.data.length;
        }
        int j = 0;
        while (j < hall.count) {
            HallTransitionImpl hItem = new HallTransitionImpl();
            HallItem item = hall.data[j];
            posn = 0.0f;
            while (cIndex < cList.size()) {
                BladeSetCalibration.Item cItem;
                if ((cItem = cList.get(cIndex++)).getSensor() != item.sensor || cItem.isOpen() != item.open) continue;
                posn = cItem.getPosition();
                break;
            }
            hItem.setTransitionTime(item.time / 1000L + hall.startTime);
            hItem.setSensorId(item.sensor);
            hItem.setOpen(item.open);
            hItem.setReverse(dist < 0.0f);
            hItem.setPosition(posn);
            hItem.setRelPosition(this.config.relPosition(posn));
            hList.add(hItem);
            ++j;
        }
        return data;
    }

    public MovementHistory moveP(int type, float dist, float time, float mvFract, int nSamp) {
        int[] iParms = new int[]{6916, 6144, 4120};
        int[] fParms = new int[]{};
        int nsamp = this.initMove(type, dist, time, mvFract, nSamp, iParms, fParms);
        MovementHistoryImpl data = new MovementHistoryImpl();
        data.setBladeSetIndex(this.bladeIndex);
        data.setStartPosition(this.getPosition());
        long sTime = 1000L * this.runMove(nsamp <= 0, null);
        data.setStartTime(sTime);
        data.setEndTime(1000L * System.currentTimeMillis());
        data.setEndPosition(this.getPosition());
        if (nsamp <= 0) {
            data.setStatus(-nsamp);
            return data;
        }
        int status = this.getPositionData(sTime, nsamp, data.getMovementProfile());
        if (status == 0) {
            status = this.moveStatus();
        }
        data.setStatus(status);
        return data;
    }

    public int home(int optns, float vel) {
        int status;
        block3: {
            float fvel = vel / 10.0f;
            float acc = 10.0f * vel;
            float jrk = 0.0f;
            this.acr.setFloatParm(12375, this.config.ppu());
            this.acr.setFloatParm(12348, vel);
            this.acr.setFloatParm(12349, acc);
            this.acr.setFloatParm(12350, acc);
            this.acr.setFloatParm(12351, jrk);
            this.acr.sendStr("axis0 jog homvf " + fvel, 0);
            this.acr.setBit(16152);
            this.acr.clearBit(16153);
            if ((optns & 2) != 0) {
                this.acr.clearBit(16154);
            } else {
                this.acr.setBit(16154);
            }
            this.enableDrive();
            status = 0;
            this.acr.sendStr("axis0 jog home " + ((optns & 1) != 0 ? -1 : 1), 0);
            do {
                this.acr.sendStr("inh -792", 0);
                if (this.acr.getBit(16134) != 0) break block3;
            } while (this.acr.getBit(16135) == 0);
            status = -1;
        }
        this.disableDrive();
        return status;
    }

    public BladeSetConfigurationDrvr getConfig() {
        return this.config;
    }

    public AccesDio getAcces() {
        return this.acd;
    }

    public Helios getHelios() {
        return this.hel;
    }

    public AcrComm getComm() {
        return this.acr;
    }

    public int moveStatus() {
        if (this.acr.getBit(522) == 0) {
            return 0;
        }
        if (this.acr.getBit(8479) != 0) {
            return 5;
        }
        if (this.acr.getBit(16132) != 0) {
            return 1;
        }
        if (this.acr.getBit(16133) != 0) {
            return 2;
        }
        if (this.acr.getBit(16140) != 0) {
            return 3;
        }
        if (this.acr.getBit(16141) != 0) {
            return 4;
        }
        return 6;
    }

    public float getDriveTemperature() {
        return this.acr.getFloatParm(28743);
    }

    public float getAmbientTemperature() {
        return 100.0f * this.hel.adCountToVolts(this.hel.adSample());
    }

    private void calibLeg(float dist, float step, float time, BladeSetCalibration calib) {
        this.configMove(0, step, time, 0.0f);
        step = Math.copySign(step, dist);
        String stepCmnd = "axis0 jog inc (" + this.config.motorDistance(step) + ")";
        int oldVal = this.acd.dioInp(this.dioHPort);
        int index = 0;
        int oldSensor = -1;
        int status = 0;
        boolean reverse = dist < 0.0f;
        float position = this.getPosition();
        float endPosition = position + dist;
        ArrayList<BladeSetCalibration.Item> cList = calib.getData();
        while (reverse ^ position - endPosition < 0.0f) {
            this.acr.sendStr(stepCmnd, 0);
            this.acr.sendStr("inh -792", 0);
            position = this.getPosition();
            int value = this.acd.dioInp(this.dioHPort);
            int chan = oldVal ^ value;
            if (chan != 0) {
                oldVal = value;
                boolean open = (chan & oldVal) != 0;
                int sensor = Integer.numberOfTrailingZeros(chan);
                if (sensor != oldSensor) {
                    index = 0;
                    oldSensor = sensor;
                } else if (!open) {
                    ++index;
                }
                cList.add(new BladeSetCalibration.Item(sensor, index, position, open, reverse));
            }
            if ((status = this.moveStatus()) != 0) break;
        }
        this.disableDrive();
        if (calib.getStatus() == 0) {
            calib.setStatus(status);
        }
    }

    private void calibLegNew(float dist, float time, Hall hall, BladeSetCalibration calib) {
        hall.count = 0;
        this.configMove(0, dist, time, 0.0f);
        this.acr.clearBit(129);
        this.acr.sendStr("run prog1", 0);
        this.acr.sendStr("inh 129", 0);
        this.acr.sendStr("axis0 jog inc " + this.config.motorDistance(dist), 0);
        this.acr.sendStr("inh -792", 0);
        int status = this.moveStatus();
        this.disableDrive();
        this.acr.sendStr("halt prog1", 0);
        this.acr.sendStr("intcap axis0 off", 0);
        int[] count = new int[1];
        this.acr.getVars(1, 0, 1, count);
        int[] posns = new int[count[0]];
        int nsamp = this.acr.getVars(1, 0, 0, count[0], posns);
        if (nsamp != count[0]) {
            calib.setStatus(7);
            return;
        }
        if (hall.count > hall.data.length) {
            if (status == 0) {
                status = 8;
            }
            hall.count = hall.data.length;
        }
        if (nsamp != hall.count) {
            if (status == 0) {
                status = 9;
            }
            if (nsamp < hall.count) {
                hall.count = nsamp;
            }
        }
        int index = 0;
        int oldSensor = -1;
        boolean reverse = dist < 0.0f;
        ArrayList<BladeSetCalibration.Item> cList = calib.getData();
        int j = 0;
        while (j < hall.count) {
            HallItem item = hall.data[j];
            if (item.sensor != oldSensor) {
                index = 0;
                oldSensor = item.sensor;
            } else if (!item.open) {
                ++index;
            }
            cList.add(new BladeSetCalibration.Item(item.sensor, index, this.config.position(posns[j]), item.open, reverse));
            ++j;
        }
        if (calib.getStatus() == 0) {
            calib.setStatus(status);
        }
    }

    private int getPositionData(long sTime, int nsamp, List<BladePosition> pList) {
        int[] times = new int[nsamp];
        int[] posns = new int[nsamp];
        int[] flags = new int[nsamp];
        int[] time0 = new int[1];
        int tsamp = this.acr.getVars(0, 0, 1, time0);
        tsamp += this.acr.getVars(0, 0, 0, nsamp, times);
        tsamp += this.acr.getVars(0, 1, 0, nsamp, posns);
        if ((tsamp += this.acr.getVars(0, 2, 0, nsamp, flags)) != 3 * nsamp + 1) {
            return 7;
        }
        int j = 0;
        while (j < nsamp) {
            BladePositionImpl pItem = new BladePositionImpl();
            pItem.setTime(sTime + (long)(1000 * (times[j] - time0[0])));
            float posn = this.config.position(posns[j]);
            pItem.setPosition(posn);
            pItem.setRelPosition(this.config.relPosition(posn));
            pList.add(pItem);
            if ((flags[j] & 0x1000000) == 0) break;
            ++j;
        }
        return 0;
    }

    private void readHallC(int value, Object parm) {
        Hall hall = (Hall)parm;
        int state = this.acd.dioInp(this.dioHPort);
        int sensor = state ^ hall.state;
        if (sensor == 0) {
            return;
        }
        hall.state = state;
        if (hall.count < hall.data.length) {
            boolean open;
            HallItem item = hall.data[hall.count];
            boolean bl = open = (sensor & state) != 0;
            if (open) {
                this.acd.dioSetBit(this.dioOPort, this.dioOLine);
            } else {
                this.acd.dioClrBit(this.dioOPort, this.dioOLine);
            }
            item.time = System.nanoTime();
            item.sensor = Integer.numberOfTrailingZeros(sensor);
            item.open = open;
        }
        ++hall.count;
    }

    private void readHallM(int value, Object parm) {
        Hall hall = (Hall)parm;
        int state = this.acd.dioInp(this.dioHPort);
        int sensor = state ^ hall.state;
        if (sensor == 0) {
            return;
        }
        hall.state = state;
        if (hall.count < hall.data.length) {
            HallItem item = hall.data[hall.count];
            item.time = System.nanoTime();
            item.sensor = Integer.numberOfTrailingZeros(sensor);
            item.open = (sensor & state) != 0;
        }
        ++hall.count;
    }

    private void configMove(int type, float dist, float time, float mvFract) {
        float jrk = 0.0f;
        if (mvFract < 0.0f) {
            mvFract = 0.0f;
        } else if (mvFract > 0.9f) {
            mvFract = 0.9f;
        }
        float vel = Math.abs(2.0f * dist / ((1.0f + mvFract) * time));
        float acc = Math.abs(4.0f * dist / ((1.0f - mvFract * mvFract) * time * time));
        if (type == 0) {
            jrk = (acc *= 2.0f) * acc / vel;
        }
        this.acr.setFloatParm(12375, this.config.ppu());
        this.acr.setFloatParm(12348, vel);
        this.acr.setFloatParm(12349, acc);
        this.acr.setFloatParm(12350, acc);
        this.acr.setFloatParm(12351, jrk);
        this.enableDrive();
    }

    private int initMove(int type, float dist, float time, float mvFract, int nSamp, int[] iParms, int[] fParms) {
        double[] parms = new double[6 + iParms.length + fParms.length];
        float jrk = 0.0f;
        if (dist == 0.0f) {
            return 0;
        }
        parms[0] = this.driveOn ? 1.0 : 0.0;
        parms[1] = this.config.motorDistance(dist);
        if (mvFract < 0.0f) {
            mvFract = 0.0f;
        } else if (mvFract > 0.9f) {
            mvFract = 0.9f;
        }
        float vel = Math.abs(2.0f * dist / ((1.0f + mvFract) * time));
        float acc = Math.abs(4.0f * dist / ((1.0f - mvFract * mvFract) * time * time));
        if (type == 0) {
            jrk = (acc *= 2.0f) * acc / vel;
        }
        if (nSamp > 0) {
            parms[2] = Math.floor(1000.0f * time / (float)nSamp);
            parms[3] = Math.floor((double)(1000.0f * time) / parms[2] + 5.0);
        } else {
            parms[2] = 1.0;
            parms[3] = 1.0;
        }
        parms[4] = iParms.length;
        parms[5] = fParms.length;
        int j = 0;
        while (j < iParms.length) {
            parms[6 + j] = iParms[j];
            ++j;
        }
        j = 0;
        while (j < fParms.length) {
            parms[6 + iParms.length + j] = fParms[j];
            ++j;
        }
        int nWord = 13 + ((int)parms[3] + 2) * (iParms.length + fParms.length);
        if (nWord > 1024) {
            return -10;
        }
        this.acr.setFloatParm(12375, this.config.ppu());
        this.acr.setFloatParm(12348, vel);
        this.acr.setFloatParm(12349, acc);
        this.acr.setFloatParm(12350, acc);
        this.acr.setFloatParm(12351, jrk);
        int count = this.acr.setUserParms(0, parms, parms.length);
        if (count < parms.length) {
            return -11;
        }
        this.acr.clearBit(128);
        this.acr.sendStr("run prog0", 0);
        this.acr.sendStr("inh 128", 0);
        this.sleep(0.1f);
        return (int)parms[3];
    }

    private long runMove(boolean dummy, Hall hall) {
        long sTime = System.currentTimeMillis();
        if (hall != null) {
            hall.startTime = 1000L * sTime - System.nanoTime() / 1000L;
        }
        if (dummy) {
            return sTime;
        }
        this.acd.dioSetBit(this.dioOPort, this.dioOLine);
        this.acr.sendStr("inh 792", 0);
        this.acr.sendStr("inh -792", 0);
        this.acr.sendStr("inh -104", 0);
        this.acd.dioClrBit(this.dioOPort, this.dioOLine);
        return sTime;
    }

    private void acrInitialize() {
        this.acr.sendStr("prog0", 0);
        this.acr.sendStr("attach axis0 enc0 dac0 enc0", 0);
        this.acr.sendStr("attach master0", 0);
        this.acr.sendStr("attach slave0 axis0 \"x\"", 0);
        this.acr.sendStr("sys", 0);
        this.acr.sendStr("halt all", 0);
        this.acr.sendStr("new all", 0);
        this.acr.sendStr("clear", 0);
        this.acr.sendStr("dim def(10)", 0);
        this.acr.sendStr("dim p(256)", 0);
        this.acr.sendStr("dim prog0(32768)", 0);
        this.acr.sendStr("dim prog1(8192)", 0);
        this.acr.sendStr("dim prog2(8192)", 0);
        this.acr.sendStr("dim prog3(8192)", 0);
        this.acr.sendStr("axis0 drive off", 0);
        this.acr.setFloatParm(12375, this.config.ppu());
        this.acr.sendStr("axis0 hldec 50000", 0);
        this.acr.sendStr("axis0 slm (" + this.config.posSoftLimit() + "," + this.config.negSoftLimit() + ")", 0);
        this.acr.sendStr("axis0 sldec 50000", 0);
        this.acr.setBit(16148);
        this.acr.setBit(16149);
        this.acr.setBit(16150);
        this.acr.setBit(16151);
        this.acr.clearBit(16146);
        this.acr.clearBit(16144);
        this.acr.clearBit(16145);
        this.acr.clearBit(522);
        this.acr.setFloatParm(12304, 0.04f);
        this.acr.setFloatParm(12305, 3.0E-4f);
        this.acr.setFloatParm(12308, 0.001f);
        this.acr.sendStr("axis0 on", 0);
        this.acr.setFloatParm(12328, 10.0f);
        this.acr.setFloatParm(12329, -10.0f);
        this.acr.sendStr("prog0", 0);
        this.acr.sendStr("program", 0);
        this.acr.sendStr("clear", 0);
        this.acr.sendStr("samp clear", 0);
        this.acr.sendStr("dim lv(10)", 0);
        this.acr.sendStr("dim la(p4)", 0);
        this.acr.sendStr("dim sa(p5)", 0);
        this.acr.sendStr("for lv0 = 0 to (p4 - 1) step 1", 0);
        this.acr.sendStr("dim la(lv0)(p3)", 0);
        this.acr.sendStr("samp(lv0) base la(lv0)", 0);
        this.acr.sendStr("samp(lv0) src p(p(lv0 + 6))", 0);
        this.acr.sendStr("next", 0);
        this.acr.sendStr("for lv0 = 0 to (p5 - 1) step 1", 0);
        this.acr.sendStr("dim sa(lv0)(p3)", 0);
        this.acr.sendStr("samp(lv0 + p4) base sa(lv0)", 0);
        this.acr.sendStr("samp(lv0 + p4) src p(p(lv0 + p4 + 6))", 0);
        this.acr.sendStr("next", 0);
        this.acr.sendStr("clr 106", 0);
        this.acr.sendStr("samp trg 792", 0);
        this.acr.sendStr("p6915 = p2", 0);
        this.acr.sendStr("if (p0 = 0) then axis0 drive on", 0);
        this.acr.sendStr("dwl 0.1", 0);
        this.acr.sendStr("set 128", 0);
        this.acr.sendStr("intcap axis0 10", 0);
        this.acr.sendStr("inh 777", 0);
        this.acr.sendStr("lv0 = p6916", 0);
        this.acr.sendStr("lv1 = p6144", 0);
        this.acr.sendStr("set 104", 0);
        this.acr.sendStr("axis0 jog inc (p1)", 0);
        this.acr.sendStr("inh -792", 0);
        this.acr.sendStr("lv2 = p6144", 0);
        this.acr.sendStr("inh -104", 0);
        this.acr.sendStr("if (p0 = 0) then axis0 drive off", 0);
        this.acr.sendStr("endp", 0);
        this.acr.sendStr("sys", 0);
    }

    private void sleep(float secs) {
        long nsecs = (long)(1.0E9f * secs);
        try {
            Thread.sleep(nsecs / 1000000L, (int)(nsecs % 1000000L));
        }
        catch (InterruptedException interruptedException) {}
    }

    public static class Hall {
        public long startTime;
        public int count;
        public int state;
        public HallItem[] data;

        public Hall() {
            this(100);
        }

        public Hall(int maxItem) {
            this.data = new HallItem[maxItem];
            int j = 0;
            while (j < maxItem) {
                this.data[j] = new HallItem();
                ++j;
            }
        }
    }

    public static class HallItem {
        public long time;
        public int sensor;
        public boolean open;
    }

    public static class SampData {
        public int status;
        public long startTime;
        public float startPosn;
        public long endTime;
        public float endPosn;
        public ArrayList<Sample> sList = new ArrayList();
    }

    public static class Sample {
        public int time;
        public int[] iVals;
        public float[] fVals;
    }
}

