/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.driver;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.lsst.ccs.subsystems.shutter.driver.BladeSetCalibration;
import org.lsst.ccs.subsystems.shutter.interfaces.BladeSetConfiguration;

public class BladeSetConfigurationDrvr
implements BladeSetConfiguration {
    private static final float POS_SOFT_LIM = 1.05f;
    private static final float NEG_SOFT_LIM = -0.05f;
    int index;
    String node;
    float ppMm;
    float homePosn;
    float openPosn;
    float clsdPosn;
    int numSamp;
    float moveTime;
    int dioAddr;
    int dioLevel;
    int dioConf;
    int dioHPort;
    int dioOPort;
    int dioOLine;
    int dioIPort;
    int dioILine;
    int adAddr;
    int adLevel;
    int adTempChn;
    BladeSetCalibration calib = new BladeSetCalibration();
    private static final String[] CALIB_FILE = new String[]{"Calibration_0.dat", "Calibration_1.dat"};
    private static final PrintStream out = System.out;

    @Override
    public void setIndex(int index) {
        this.index = index;
        if (index == 0) {
            this.node = "192.168.100.1";
            this.ppMm = -49.3504f;
            this.homePosn = 0.0f;
            this.openPosn = 0.0f;
            this.clsdPosn = 760.0f;
            this.moveTime = 1.0f;
            this.numSamp = 100;
            this.dioAddr = 832;
            this.dioLevel = 6;
            this.dioConf = 7;
            this.dioHPort = 0;
            this.dioIPort = 2;
            this.dioILine = 0;
            this.dioOPort = 2;
            this.dioOLine = 4;
            this.adAddr = 640;
            this.adLevel = 5;
            this.adTempChn = 0;
        } else {
            this.node = "192.168.100.1";
            this.ppMm = 49.3504f;
            this.homePosn = 760.0f;
            this.openPosn = 760.0f;
            this.clsdPosn = 0.0f;
            this.moveTime = 1.0f;
            this.numSamp = 100;
            this.dioAddr = 832;
            this.dioLevel = 6;
            this.dioConf = 7;
            this.dioHPort = 0;
            this.dioIPort = 2;
            this.dioILine = 0;
            this.dioOPort = 2;
            this.dioOLine = 4;
            this.adAddr = 640;
            this.adLevel = 5;
            this.adTempChn = 0;
        }
        this.readCalibration();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setCalibration(BladeSetCalibration calib) {
        this.calib = calib;
    }

    public BladeSetCalibration getCalibration() {
        return this.calib;
    }

    public String getNode() {
        return this.node;
    }

    public float getPpMm() {
        return this.ppMm;
    }

    public float getHome() {
        return this.homePosn;
    }

    public float getOpen() {
        return this.openPosn;
    }

    public float getClosed() {
        return this.clsdPosn;
    }

    public float getMoveTime() {
        return this.moveTime;
    }

    public int getNumSamp() {
        return this.numSamp;
    }

    public int getDioAddr() {
        return this.dioAddr;
    }

    public int getDioLevel() {
        return this.dioLevel;
    }

    public int getDioConf() {
        return this.dioConf;
    }

    public int getDioHPort() {
        return this.dioHPort;
    }

    public int getDioIPort() {
        return this.dioIPort;
    }

    public int getDioILine() {
        return this.dioILine;
    }

    public int getDioOPort() {
        return this.dioOPort;
    }

    public int getDioOLine() {
        return this.dioOLine;
    }

    public int getAdAddr() {
        return this.adAddr;
    }

    public int getAdLevel() {
        return this.adLevel;
    }

    public int getAdTempChn() {
        return this.adTempChn;
    }

    public float ppu() {
        return Math.abs(this.ppMm);
    }

    public float motorDistance(float dist) {
        return Math.signum(this.ppMm) * dist;
    }

    public float position(int encoder) {
        return this.homePosn + (float)encoder / this.ppMm;
    }

    public float position(float relPosition) {
        return this.openPosn + relPosition * (this.clsdPosn - this.openPosn);
    }

    public float relPosition(int encoder) {
        return ((float)encoder / this.ppMm + this.homePosn - this.openPosn) / (this.clsdPosn - this.openPosn);
    }

    public float relPosition(float position) {
        return (position - this.openPosn) / (this.clsdPosn - this.openPosn);
    }

    public float posSoftLimit() {
        float reach = Math.signum(this.ppMm) * (this.clsdPosn - this.openPosn);
        return (reach > 0.0f ? 1.05f : -0.05f) * reach;
    }

    public float negSoftLimit() {
        float reach = Math.signum(this.ppMm) * (this.clsdPosn - this.openPosn);
        return (reach > 0.0f ? -0.05f : 1.05f) * reach;
    }

    public int readCalibration() {
        return this.readCalibration(CALIB_FILE[this.index]);
    }

    public int readCalibration(String file) {
        FileInputStream ifl = null;
        try {
            ifl = new FileInputStream(file);
        }
        catch (IOException e) {
            out.println(e);
            return -1;
        }
        this.calib.setStatus(0);
        ArrayList<BladeSetCalibration.Item> list = this.calib.getData();
        list.clear();
        Scanner inp = new Scanner(ifl);
        int line = 0;
        int field = 0;
        int sensor = 0;
        int indx = 0;
        float posn = 0.0f;
        boolean open = false;
        boolean reverse = false;
        try {
            while (inp.hasNext()) {
                switch (field) {
                    case 0: {
                        reverse = inp.next("[+-]").equals("-");
                        break;
                    }
                    case 1: {
                        sensor = inp.nextInt();
                        break;
                    }
                    case 2: {
                        indx = inp.nextInt();
                        break;
                    }
                    case 3: {
                        open = inp.next("[OC]").equals("O");
                        break;
                    }
                    case 4: {
                        posn = inp.nextFloat();
                        list.add(new BladeSetCalibration.Item(sensor, indx, posn, open, reverse));
                        field = -1;
                        ++line;
                        inp.nextLine();
                    }
                }
                ++field;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            out.format("Invalid field (%s) in line %s\n", field + 1, line + 1);
            list.clear();
            field = 0;
            line = 0;
        }
        if (field != 0) {
            out.format("File ended unexpectedly in line %s\n", line + 1);
            list.clear();
            line = 0;
        }
        try {
            ifl.close();
        }
        catch (IOException iOException) {}
        return line;
    }

    public void writeCalibration() {
        BladeSetConfigurationDrvr.writeCalibration(this.calib, CALIB_FILE[this.index]);
    }

    public void writeCalibration(BladeSetCalibration calib) {
        BladeSetConfigurationDrvr.writeCalibration(calib, CALIB_FILE[this.index]);
    }

    public void writeCalibration(String file) {
        BladeSetConfigurationDrvr.writeCalibration(this.calib, file);
    }

    public static void writeCalibration(BladeSetCalibration calib, String file) {
        PrintStream ofl;
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            out.println(e);
            return;
        }
        ArrayList<BladeSetCalibration.Item> list = calib.getData();
        int j = 0;
        while (j < list.size()) {
            BladeSetCalibration.Item tran = list.get(j);
            ofl.format("%s %s %s %s %8.2f\n", tran.isReverse() ? "-" : "+", tran.getSensor(), tran.getIndex(), tran.isOpen() ? "O" : "C", Float.valueOf(tran.getPosition()));
            ++j;
        }
        ofl.close();
    }
}

