/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.common;

import data.DiscretePlotData;
import data.MetaData;
import data.SuggestedRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;

public class MotorHistory
implements DiscretePlotData,
Serializable {
    private List<MotorSpeed> history = new ArrayList<MotorSpeed>();
    private final String[] names = new String[]{"Time", "Acceleration", "Velocity", "Position"};

    public List<MotorSpeed> getList() {
        return this.history;
    }

    public void setList(List<MotorSpeed> list) {
        this.history = list;
    }

    public void reset() {
        this.history.clear();
    }

    public void addData(double time, double acceleration, double velocity, double position) {
        this.history.add(new MotorSpeed(time, acceleration, velocity, position));
    }

    public int getNPoints() {
        return this.history.size();
    }

    public int getNDimensions() {
        return this.names.length;
    }

    public String names(int index) {
        return this.names[index];
    }

    public Class types(int index) {
        return Double.TYPE;
    }

    public void getValue(Value value, int dim, int index) {
        MotorSpeed speed = this.history.get(index);
        switch (dim) {
            case 0: {
                value.set(speed.getDate());
                break;
            }
            case 1: {
                value.set(speed.getAcceleration());
                break;
            }
            case 2: {
                value.set(speed.getVelocity());
                break;
            }
            case 3: {
                value.set(speed.getPosition());
            }
        }
    }

    public MetaData getMetaData() {
        return null;
    }

    public String getTitle() {
        return "Motor History";
    }

    public SuggestedRange getSuggestedRange() {
        return null;
    }

    private static class MotorSpeed
    implements Serializable {
        private double date;
        private double acceleration;
        private double velocity;
        private double position;

        public MotorSpeed(double date, double acceleration, double velocity, double position) {
            this.date = date;
            this.acceleration = acceleration;
            this.velocity = velocity;
            this.position = position;
        }

        public double getAcceleration() {
            return this.acceleration;
        }

        public double getDate() {
            return this.date;
        }

        public double getPosition() {
            return this.position;
        }

        public double getVelocity() {
            return this.velocity;
        }
    }
}

