package org.lsst.ccs.subsystems.shutter.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

/**
 * The shutter assembly consists of two shutters, each of which has three
 * blades.
 * @author tonyj
 */
public class ShutterAssembly extends JComponent {

    private List<Shutter> shutters = new ArrayList<Shutter>();

    ShutterAssembly() {
        setPreferredSize(new Dimension(500, 400));
        shutters.add(new Shutter(100, 400));
        shutters.add(new Shutter(100, 400));

        shutters.get(0).setShutterPosition(0);
        shutters.get(1).setShutterPosition(1);
    }

    Shutter getShutter(int index) {
        return shutters.get(index);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);
        //Paint the camera.
        Shape circle = new Arc2D.Float(100, 50, 300, 300, 0, 360, Arc2D.CHORD);
        g2.draw(circle);

        shutters.get(0).paint(g2);
        AffineTransform saveAt = g2.getTransform();
        g2.translate(500, 0);
        g2.scale(-1,1);
        shutters.get(1).paint(g2);
        g2.setTransform(saveAt);

    }

    static class Shutter {

        private List<Blade> blades = new ArrayList<Blade>();

        Shutter(int bladeWidth, int bladeHeight) {
            for (int i = 0; i < 3; i++) {
                blades.add(new Blade(bladeWidth, bladeHeight));
            }
        }

        /**
         * Set the shutter position
         * @param pos 0=open, 1=closed, 0.5 neither up nor down
         */
        void setShutterPosition(float pos) {
            pos = Math.max(0, Math.min(1, pos));
            blades.get(0).setPosition(100 * pos);
            blades.get(1).setPosition(200 * pos);
            blades.get(2).setPosition(300 * pos);
        }

        float getShutterPosition() {
            return blades.get(0).setPosition() / 100;
        }

        void paint(Graphics2D g2) {
            for (Blade blade : blades) {
                blade.paint(g2);
            }
        }
    }

    private static class Blade extends Rectangle.Float {

        Blade(int width, int height) {
            super(0, 0, width, height);
        }

        void setPosition(float x) {
            this.x = x;
        }

        float setPosition() {
            return this.x;
        }

        private void paint(Graphics2D g2) {
            g2.setColor(new Color(.5f, .5f, .5f, .5f));
            g2.fill(this);
            g2.setColor(Color.BLACK);
            g2.draw(this);
        }
    }
}
