package org.lsst.ccs.subsystems.shutter.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.subsystems.shutter.common.MotorHistory;
import plotter.Axis;
import plotter.Axis.AxisPosition;
import plotter.ContinuousAxisModel;
import plotter.DataArea;
import plotter.LineChartOverlay;
import plotter.LinearAxisModel;
import plotter.PlotLayout;


/**
 *
 * @author tonyj
 */
public class PlotPanel extends JPanel {

    private LinearAxisModel yAxisModel;
    private ContinuousAxisModel xAxisModel;
    private DataArea da;
    KeyPanel[] keyPanels = new KeyPanel[2];
    private JPanel plotPanel;
    private MotorHistory[] histories = new MotorHistory[2];

    PlotPanel() {

        super(new GridBagLayout());

        plotPanel = new JPanel(new PlotLayout());
        plotPanel.setPreferredSize(new Dimension(500, 300));

        xAxisModel = new LinearAxisModel(-1.1, 1.1);
        yAxisModel = new LinearAxisModel(0, 5);
        Axis xAxis = new Axis(xAxisModel, AxisPosition.LEFT);
        Axis yAxis = new Axis(yAxisModel, AxisPosition.BOTTOM);

        da = new DataArea(yAxis, xAxis);
        plotPanel.add(xAxis);
        plotPanel.add(yAxis);
        plotPanel.add(da);

        keyPanels[0] = new KeyPanel("Motor 1");
        keyPanels[1] = new KeyPanel("Motor 2");

        histories[0] = new MotorHistory();
        histories[1] = new MotorHistory();

        MotorHistory motor1 = histories[0];

        LineChartOverlay acceleration1 = new LineChartOverlay("Acceleration", motor1, 0, 1, yAxisModel, xAxisModel);
        da.add(acceleration1);
        acceleration1.setLineColor(Color.RED);

        LineChartOverlay velocity1 = new LineChartOverlay("Velocity", motor1, 0, 2, yAxisModel, xAxisModel);
        da.add(velocity1);
        velocity1.setLineColor(Color.BLUE);

        LineChartOverlay position1 = new LineChartOverlay("Position", motor1, 0, 3, yAxisModel, xAxisModel);
        da.add(position1);
        position1.setLineColor(Color.GREEN);

        keyPanels[0].add(acceleration1);
        keyPanels[0].add(velocity1);
        keyPanels[0].add(position1);

        MotorHistory motor2 = histories[1];

        LineChartOverlay acceleration2 = new LineChartOverlay("Acceleration", motor2, 0, 1, yAxisModel, xAxisModel);
        da.add(acceleration2);
        acceleration2.setLineColor(Color.ORANGE);

        LineChartOverlay velocity2 = new LineChartOverlay("Velocity", motor2, 0, 2, yAxisModel, xAxisModel);
        da.add(velocity2);
        velocity2.setLineColor(Color.CYAN);

        LineChartOverlay position2 = new LineChartOverlay("Position", motor2, 0, 3, yAxisModel, xAxisModel);
        da.add(position2);
        position2.setLineColor(Color.MAGENTA);

        keyPanels[1].add(acceleration2);
        keyPanels[1].add(velocity2);
        keyPanels[1].add(position2);


        JPanel key = new JPanel(new BorderLayout());
        key.add(BorderLayout.NORTH, keyPanels[0]);
        key.add(BorderLayout.SOUTH, keyPanels[1]);
        key.setBorder(BorderFactory.createTitledBorder("Key"));

        GridBagConstraints c = new GridBagConstraints();
        c.gridx = GridBagConstraints.REMAINDER;
        add(plotPanel, c);
        add(key, c);

////        histories.get(1).addPlotDataListener(new PlotDataListener() {
//
//            @Override
//            public void dataChanged() {
//                repaint();
//            }
//        });
    }

    public void clearPlot() {
        histories[0].reset();
        histories[1].reset();
        repaint();
    }

    public void plotMotorHistory(MotorHistory history, int motor) {
        histories[motor].setList(history.getList());
        repaint();
    }

    void setTimePeriod(double time) {
        yAxisModel.setMax(time);
        repaint();
    }

    private static class KeyPanel extends JPanel {

        KeyPanel(String title) {
            super(new FlowLayout());
            add(new JLabel(title));
        }

        private void add(LineChartOverlay overlay) {
            JLabel label = new JLabel(overlay.getTitle());
            label.setIcon(overlay.getKeyIcon());
            add(label);
        }
    }
}
