/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.shutter.status;

import org.lsst.ccs.bus.Status;
import org.lsst.ccs.subsystems.shutter.ShutterModule;

/**
 *
 * @author turri
 */
public class ShutterStatus extends Status {

    private double exposureTime, openTime;
    private boolean isFirstBladeInOpenPosition;

    public ShutterStatus (ShutterModule shutter) {
        super();
        this.exposureTime = shutter.getExposureTimeSeconds();
        this.openTime = shutter.getMoveTimeSeconds();
    }

    public double getExposureTimeSeconds() {
        return exposureTime;
    }

    public double getMoveTimeSeconds() {
        return openTime;
    }

    @Override
    public String getMessageType() {
        return "org.lsst.ccs.shutter.status";
    }

    @Override
    public String toString() {
        return super.toString() +" {exposureTime = "+getExposureTimeSeconds()+"; openTime = "+getMoveTimeSeconds()+"}";
    }

    @Override
    public boolean equals(Object obj) {
        if ( ! (obj instanceof ShutterStatus) )
            return false;
        ShutterStatus ss = (ShutterStatus) obj;
        if ( ss.getExposureTimeSeconds() != getExposureTimeSeconds() )
            return false;
        if ( ss.getMoveTimeSeconds() != getMoveTimeSeconds() )
            return false;
        return true;
    }




}
