package org.lsst.ccs.subsystems.shutter.simulator.motor;

import org.lsst.ccs.subsystems.shutter.common.HallTransitionImpl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
//import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author azemoon
 */
public class ShutterSimulator {
    
    final static double MAXCLOSETIME = 2;
    private EventListenerList listeners = new EventListenerList();
    private List<BladeSetSimulator> bladeSetSimulators = new ArrayList<BladeSetSimulator>();

    public ShutterSimulator() {
        bladeSetSimulators.add(new BladeSetSimulator());
        bladeSetSimulators.get(0).setIndex(0);
        bladeSetSimulators.add(new BladeSetSimulator());
        bladeSetSimulators.get(1).setIndex(1);
    }

    public void start() {
        for (int i = 0; i <=1 ; i++) {
            addEncoderSimulatorListener(i, new EncoderSimulatorListener() {
                @Override
                public void encoderSimulatorReady(List<MotorPosition> h) {
                     // write on the status bus here
                }
            });

            addHallSensorListener(i, new HallSensorListener() {
                @Override
                public void hallSensorTransition(HallTransitionImpl h) {
                    // write on the status bus here
                }
            });
        }


    }

    public void addChangeListener(ChangeListener l) {
        listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        listeners.remove(ChangeListener.class, l);
    }


    public void addEncoderSimulatorListener (int index, EncoderSimulatorListener l) {
        bladeSetSimulators.get(index).addEncoderSimulatorListener(l);
    }

    public void removeEncoderSimulatorListener (int index, EncoderSimulatorListener l) {
        bladeSetSimulators.get(index).removeEncoderSimulatorListener(l);
    }

    public void addHallSensorListener (int index, HallSensorListener l) {
        bladeSetSimulators.get(index).addHallSensorListener(l);
    }

    public void removeHallSensorListener (int index, HallSensorListener l) {
        bladeSetSimulators.get(index).removeHallSensorListener(l);
    }

    public void moveToPosition(final int index, float targetPosition, final float moveTimeSeconds, boolean initialize) {
        final BladeSetSimulator bladeSetSimulator = bladeSetSimulators.get(index);
        double currentPosition = bladeSetSimulator.getBladeSetPosition();
        //System.out.println("UI: currentPosition " + currentPosition + "targetPosition  " + targetPosition );
        boolean retractBladeSet = targetPosition < currentPosition;

        if (!retractBladeSet && initialize){
            double safeTargetPosition = 1 - bladeSetSimulators.get(1-index).getBladeSetPosition();
            if ( targetPosition > safeTargetPosition ) {
                System.out.println("********* Unsafe operation, end position modified ******* ");
                targetPosition = (float) safeTargetPosition;
                System.out.println("UI: currentPosition " + currentPosition + "targetPosition  " + targetPosition );
            }
        }

        bladeSetSimulator.addEncoderSimulatorListener(new EncoderSimulatorListener() {
            @Override
            public void encoderSimulatorReady(List<MotorPosition> h) {
                // write on the status bus here
                bladeSetSimulator.removeEncoderSimulatorListener(this);
            }
        });

        bladeSetSimulator.addHallSensorListener(new HallSensorListener() {
            @Override
            public void hallSensorTransition(HallTransitionImpl h) {
                // write on the status bus here
                bladeSetSimulator.removeHallSensorListener(this);
            }
        });

        bladeSetSimulator.moveToPosition(targetPosition, moveTimeSeconds);

    }

    public void takeImage(final int firstBladeSetIndex, final float moveTimeSeconds, final float exposureTimeSeconds) {
        int exposureTime = (int) (1000 * exposureTimeSeconds);
        //double currentPosition = bladeSetSimulators.get(0).getBladeSetPosition();
        //boolean retractBladeSet0 = currentPosition > 0.5;

        // Which motor starts first
        //final int firstBladeSetIndex = retractBladeSet0 ? 0 : 1;
        final int secondBladeSetIndex = 1 - firstBladeSetIndex;
        final float firstTargetPosition = 0;
        final float secondTargetPosition = 1;


        Timer timer1 = new Timer(exposureTime, new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                moveToPosition(secondBladeSetIndex, secondTargetPosition, moveTimeSeconds, false);
            }
        });
        timer1.setRepeats(false);

        timer1.start();
        moveToPosition(firstBladeSetIndex, firstTargetPosition, moveTimeSeconds, true);
   }

   public void takeImage(final float moveTimeSeconds, final float exposureTimeSeconds) {
        double position0 = bladeSetSimulators.get(0).getBladeSetPosition();
        double position1 = bladeSetSimulators.get(1).getBladeSetPosition();
        //System.out.println("ShutterSimulator: ***** " + position0 + " " + position1 + " *******");
        //final double targetPosition;
        if ( ( position0 == 0 && position1 == 1) || ( position0 == 1 && position1 == 0) ) {
            final int firstBladeSetIndex = (position0 < position1) ? 1 : 0;
            takeImage(firstBladeSetIndex, moveTimeSeconds, exposureTimeSeconds);
        }  else {
            System.out.println("ShutterSimulator: reset positions***** ");
        }
   }
   
   public void closeShutter() {
        double position0 = bladeSetSimulators.get(0).getBladeSetPosition();
        double position1 = bladeSetSimulators.get(1).getBladeSetPosition();
        //System.out.println("ShutterSimulator: ***** " + position0 + " " + position1 + " *******");
        if ( ( position0 == 0 && position1 == 1) || ( position0 == 1 && position1 == 0) ) {
            System.out.println("Shutter already closed ***** ");
        }  else {            
            final int firstBladeSetIndex = (position0 < position1) ? 0 : 1;
            final int secondBladeSetIndex = 1 - firstBladeSetIndex;
            final double moveTimeSeconds = MAXCLOSETIME;// * (1 - Math.max(position0, position1));
            if (position0 == 0 || position1 == 0) {
                moveToPosition(secondBladeSetIndex, 1, (float) moveTimeSeconds, true);
            } else {

                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        moveToPosition(secondBladeSetIndex, 1 , (float) moveTimeSeconds, false);
                    }
                });
                t.start();
                moveToPosition(firstBladeSetIndex, 0, (float) moveTimeSeconds, true);
            }
        }
   }
}
