package org.lsst.ccs.subsystems.shutter.simulator.motor;

import org.lsst.ccs.subsystems.shutter.interfaces.BladeSet;
import org.lsst.ccs.subsystems.shutter.interfaces.BladeSetConfiguration;
import org.lsst.ccs.subsystems.shutter.interfaces.MovementHistory;

import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import java.util.List;

/**
 *
 * @author azemoon
 */
// public class BladeSetSimulator implements BladeSet {
public class BladeSetSimulator {
    private EventListenerList listeners = new EventListenerList();
    private MotorSimulator motorSimulator;
    private MotorEncoderSimulator encoderSimulator;
    private HallSensorSimulator hallSensorSimulator;
    private int index;

    public BladeSetSimulator() {
        motorSimulator = new MotorSimulator();
        encoderSimulator = new MotorEncoderSimulator(motorSimulator);
        hallSensorSimulator = new HallSensorSimulator(motorSimulator);
    }
/*
    @Override
    public BladeSetConfiguration getBladeSetConfiguration() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
*/

//    @Override
    public float getCurrentPosition() {
        return (float) motorSimulator.getInitialMotorPosition();
    }

    

//    @Override
    public void setIndex(int index) {
        this.index = index;
        if ( index == 0 ){
            motorSimulator.setInitialMotorPosition(0);
        } else {
            motorSimulator.setInitialMotorPosition(1);
        }
    }

    public void start() {
    }
    public double getBladeSetPosition() {
        return motorSimulator.getInitialMotorPosition();
    }

    public void addChangeListener(ChangeListener l) {
        listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        listeners.remove(ChangeListener.class, l);
    }


    public void addEncoderSimulatorListener(EncoderSimulatorListener l) {
        encoderSimulator.addEncoderSimulatorListener(l);
    }

    public void removeEncoderSimulatorListener(EncoderSimulatorListener l) {
        encoderSimulator.removeEncoderSimulatorListener(l);
    }

    public void addHallSensorListener(HallSensorListener l) {
        hallSensorSimulator.addHallSensorListener(l);
    }

    public void removeHallSensorListener(HallSensorListener l) {
        hallSensorSimulator.removeHallSensorListener(l);
    }

    public void moveToPosition( float targetPosition, float moveTimeSeconds) {

        encoderSimulator.addEncoderSimulatorListener(new EncoderSimulatorListener() {

            @Override
            public void encoderSimulatorReady(List<MotorPosition> h) {
                
                encoderSimulator.removeEncoderSimulatorListener(this);
            }
        });
/*        
        hallSensorSimulator.addHallSensorListener(new HallSensorListener() {
            @Override
            public void hallSensorTransition(HallTransitionImpl h) {
                // write on the status bus here
                bladeSetSimulator.removeHallSensorListener(this);
            }
        });
 *
 */
        motorSimulator.simulateMovement(targetPosition, (double) moveTimeSeconds);
    }
}
