/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.shutter.interfaces;

import java.util.List;

public interface MovementHistory {

    /**
     *  Get BladeSet Index that produced the movement.
     *
     */
    public int getBladeSetIndex();

    /**
     *  Get the movement completion status
     *
     */
    public int getStatus();

    /**
     *  Get the start time of the movement in Epoch microseconds.
     *
     */
    public long getStartTime();

    /**
     *  Get the end time of the movement in Epoch microseconds.
     *
     */
    public long getEndTime();

    /**
     *  Get the position at the beginning of the movement.
     *  This is a number [0,1].
     *
     */
    public float getStartPosition();

    /**
     *  Get the position at the end of the movement.
     *  This is a number [0,1].
     *
     */
    public float getEndPosition();

    /**
     *  Get the profile of the movement.
     *  The profile is time ordered.
     *
     */
    public List<BladePosition> getMovementProfile();

    /**
     *  Get the list of Hall Sensor transitions corresponding to this movement.
     *  The transitions are globally time ordered.
     *
     */
    public List<HallTransition> getHallTransitions();

}
