package org.lsst.ccs.subsystems.shutter.gui;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;
import util.ListenerList;


/**
 *
 * @author tonyj
 */
public class MotorHistory implements DiscretePlotData, MutablePlotData {

    private final List<MotorSpeed> history = new ArrayList<MotorSpeed>();
    private final ListenerList<PlotDataListener> listeners = new ListenerList<PlotDataListener>();
    private final String[] names = {"Time", "Acceleration", "Velocity", "Position"};
    private long startTime = 0;
    public void MotorHistory() {
    }

    public void reset() {
       startTime = 0;
       history.clear();
       firePlotDataChanged();
    }

    public void addData(long time, double acceleration, double velocity, double position) {
        if ( startTime == 0) startTime = time;
        //System.out.println("MotorHistory: time " + time + " position " + position);
        history.add(new MotorSpeed((time - startTime)/1000.,acceleration,velocity,position));
        firePlotDataChanged();
    }

    @Override
    public int getNPoints() {
        return history.size();
    }

    @Override
    public int getNDimensions() {
        return names.length;
    }

    @Override
    public String names(int index) {
        return names[index];
    }

    @Override
    public Class types(int index) {
        return Double.TYPE;
    }

    @Override
    public void getValue(Value value, int dim, int index) {
        MotorSpeed speed = history.get(index);
        switch (dim) {
            case 0: value.set(speed.getDate()); break;
            case 1: value.set(speed.getAcceleration()); break;
            case 2: value.set(speed.getVelocity()); break;
            case 3: value.set(speed.getPosition()); break;
        }
    }

    @Override
    public MetaData getMetaData() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Motor History";
    }

    @Override
    public SuggestedRange getSuggestedRange() {
        return null;
    }

    @Override
    public void addPlotDataListener(PlotDataListener listener) {
        listeners.addListener(listener);
    }

    @Override
    public void removePlotDataListener(PlotDataListener listener) {
        listeners.removeListener(listener);
    }

    private void firePlotDataChanged() {
        if (!listeners.isEmpty()) {
            for (PlotDataListener l : listeners.getListeners()) {
                l.dataChanged();
            }
        }
    }

    @Override
    public Object lock() {
        return history;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime (long startTime){
        this.startTime = startTime;
    }

    private static class MotorSpeed {

        private double date;
        private double acceleration;
        private double velocity;
        private double position;

        public MotorSpeed(double date, double acceleration, double velocity, double position) {
            this.date = date;
            this.acceleration = acceleration;
            this.velocity = velocity;
            this.position = position;
        }

        public double getAcceleration() {
            return acceleration;
        }

        public double getDate() {
            return date;
        }

        public double getPosition() {
            return position;
        }

        public double getVelocity() {
            return velocity;
        }
    }

}
