package org.lsst.ccs.subsystems.shutter.driver;

import java.util.ArrayList;

/**
 ***************************************************************************
 **
 **  Class to hold blade calibration data
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class BladeSetCalibration {

    int              status;    // Calibration status
    ArrayList<Item>  data;      // Calibration data

   /**
    ***************************************************************************
    **
    **  Inner class to hold a single blade calibration data item
    **
    ***************************************************************************
    */
    public static class Item {

        int      sensor;     // Sensor ID
        int      index;      // Instance number of sensor open-close cycle
        float    position;   // BladeSet position
        boolean  open;       // True if switch opened; false if closed
        boolean  reverse;    // True if reverse move; false if forward


        public Item()
        {
        }


        public Item(int sensor, int index, float position, boolean open,
                    boolean reverse)
        {
            this.sensor   = sensor;
            this.index    = index;
            this.position = position;
            this.open     = open;
            this.reverse  = reverse;
        }


        public void setSensor(int sensor)
        {
            this.sensor = sensor;
        }


        public void setIndex(int index)
        {
            this.index = index;
        }


        public void setPosition(float position)
        {
            this.position = position;
        }


        public void setOpen(boolean open)
        {
            this.open = open;
        }


        public void setReverse(boolean reverse)
        {
            this.reverse = reverse;
        }


        public int getSensor()
        {
            return sensor;
        }


        public int getIndex()
        {
            return index;
        }


        public float getPosition()
        {
            return position;
        }


        public boolean isOpen()
        {
            return open;
        }


        public boolean isReverse()
        {
            return reverse;
        }

    }


    public BladeSetCalibration()
    {
        data = new ArrayList<Item>();
    }


    public void setStatus(int status)
    {
        this.status = status;
    }


    public void setData(ArrayList<BladeSetCalibration.Item> data)
    {
        this.data = data;
    }


    int getStatus()
    {
        return status;
    }


    ArrayList<BladeSetCalibration.Item> getData()
    {
        return data;
    }

}
