/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.TopContext;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TopContextTest {
    @Test
    public void testTransitions() throws InterruptedException {
        TopContext sm = new TopContext((Actions)Mockito.mock(Actions.class));
        Actions act = sm.getActions();
        Channel chan = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)act.makePartialContact()).thenReturn((Object)true);
        Mockito.when((Object)act.makeFullContact()).thenReturn((Object)true);
        sm.init();
        sm.plcIsDisabled(chan);
        sm.ignored(chan, null);
        sm.resync(chan);
        sm.plcIsEnabled(chan);
        sm.contactLost(chan, "Contact was lost.");
        sm.resync(chan);
        sm.syncTimeout(chan);
        InOrder order = Mockito.inOrder((Object[])new Object[]{act});
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNCHRONIZING);
        ((Actions)order.verify((Object)act)).makePartialContact();
        ((Actions)order.verify((Object)act)).resetPLC();
        ((Actions)order.verify((Object)act)).startSyncTimer();
        ((Actions)order.verify((Object)act)).cancelSyncTimer();
        ((Actions)order.verify((Object)act)).makeFullContact();
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNC_ERROR);
        ((Actions)order.verify((Object)act)).terminateContact();
        ((Actions)order.verify((Object)act)).raiseSyncAlert((String)ArgumentMatchers.any());
        ((Actions)order.verify((Object)act)).setPhysicalState(PhysicalState.OTHER);
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNCHRONIZING);
        ((Actions)order.verify((Object)act)).makePartialContact();
        ((Actions)order.verify((Object)act)).resetPLC();
        ((Actions)order.verify((Object)act)).startSyncTimer();
        ((Actions)order.verify((Object)act)).cancelSyncTimer();
        ((Actions)order.verify((Object)act)).makeFullContact();
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNC_ERROR);
        ((Actions)order.verify((Object)act)).terminateContact();
        ((Actions)order.verify((Object)act)).raiseSyncAlert((String)ArgumentMatchers.any());
        ((Actions)order.verify((Object)act)).setPhysicalState(PhysicalState.OTHER);
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNCHRONIZING);
        ((Actions)order.verify((Object)act)).makePartialContact();
        ((Actions)order.verify((Object)act)).resetPLC();
        ((Actions)order.verify((Object)act)).startSyncTimer();
        ((Actions)order.verify((Object)act)).cancelSyncTimer();
        ((Actions)order.verify((Object)act)).setSoftwareState(SoftwareState.SYNC_ERROR);
        ((Actions)order.verify((Object)act)).terminateContact();
        ((Actions)order.verify((Object)act)).raiseSyncAlert((String)ArgumentMatchers.any());
        ((Actions)order.verify((Object)act)).setPhysicalState(PhysicalState.OTHER);
        order.verifyNoMoreInteractions();
    }

    @Test
    public void testContactFailure() throws InterruptedException {
        TopContext sm = new TopContext((Actions)Mockito.mock(Actions.class));
        Actions act = sm.getActions();
        Channel chan = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)act.makePartialContact()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        Mockito.when((Object)act.makeFullContact()).thenReturn((Object)false);
        sm.init();
        sm.plcIsDisabled(chan);
        sm.contactLost(chan, "Contact was lost.");
        sm.resync(chan);
        sm.plcIsEnabled(chan);
        sm.contactLost(chan, "Contact was lost.");
        InOrder order = Mockito.inOrder((Object[])new Object[]{act});
        ((Actions)order.verify((Object)act)).makePartialContact();
        ((Actions)order.verify((Object)act)).raiseSyncAlert((String)ArgumentMatchers.any());
        ((Actions)order.verify((Object)act)).setPhysicalState(PhysicalState.OTHER);
        ((Actions)order.verify((Object)act)).makePartialContact();
        ((Actions)order.verify((Object)act)).resetPLC();
        ((Actions)order.verify((Object)act)).makeFullContact();
        ((Actions)order.verify((Object)act)).raiseSyncAlert((String)ArgumentMatchers.any());
        ((Actions)order.verify((Object)act)).setPhysicalState(PhysicalState.OTHER);
        order.verifyNoMoreInteractions();
    }

    @Test
    public void testBrakePowerEvents() throws InterruptedException {
        TopContext sm = (TopContext)Mockito.spy((Object)new TopContext((Actions)Mockito.mock(Actions.class)));
        Actions act = sm.getActions();
        sm.init();
        Assertions.assertFalse((boolean)sm.brakePowerIsOn(), (String)"Brake power flag was not initialized to false.");
        Channel chan = (Channel)Mockito.mock(Channel.class);
        sm.brakePowerChange(chan, true);
        ((Channel)Mockito.verify((Object)chan, (VerificationMode)Mockito.times((int)1))).write((Object)EventReply.accepted());
        Assertions.assertTrue((boolean)sm.brakePowerIsOn(), (String)"Brake power flag was not made true when requested.");
        ((TopContext)Mockito.verify((Object)sm, (VerificationMode)Mockito.never())).sendBrakePowerLossEvent();
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).publishBrakePowerStatus(true);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.never())).publishBrakePowerStatus(false);
        chan = (Channel)Mockito.mock(Channel.class);
        sm.brakePowerChange(chan, false);
        ((Channel)Mockito.verify((Object)chan, (VerificationMode)Mockito.times((int)1))).write((Object)EventReply.accepted());
        Assertions.assertFalse((boolean)sm.brakePowerIsOn(), (String)"Brake power flag was not made false when requested.");
        ((TopContext)Mockito.verify((Object)sm, (VerificationMode)Mockito.times((int)1))).sendBrakePowerLossEvent();
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).publishBrakePowerStatus(true);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).publishBrakePowerStatus(false);
        chan = (Channel)Mockito.mock(Channel.class);
        sm.brakePowerChange(chan, false);
        ((Channel)Mockito.verify((Object)chan, (VerificationMode)Mockito.times((int)1))).write((Object)EventReply.accepted());
        Assertions.assertFalse((boolean)sm.brakePowerIsOn(), (String)"Brake power flag did not remain false when set to false.");
        ((TopContext)Mockito.verify((Object)sm, (VerificationMode)Mockito.times((int)1))).sendBrakePowerLossEvent();
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).publishBrakePowerStatus(true);
        ((Actions)Mockito.verify((Object)act, (VerificationMode)Mockito.times((int)1))).publishBrakePowerStatus(false);
    }
}

