package org.lsst.ccs.subsystem.shutter.plc;

import org.lsst.ccs.subsystem.shutter.common.Axis;
import java.nio.ByteBuffer;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;

/**
 * Signals the PLC to clear faults on one of the axes.
 * @author tether
 */
public class ClearAxisFaultsPLC extends MsgToPLC {

    private final ClearAxisFaults msg;

    /**
     * Constructs using an instance of the motorplatform ClearAxisFaults message.
     * @param msg Used to supply the message-specific data.
     * @see ClearAxisFaults
     */
    public ClearAxisFaultsPLC(final ClearAxisFaults msg) {
        this.msg = msg;
    }

    /**
     * Reads and converts the PLC form of the message.
     * @param data The PLC message data buffer.
     */
    public ClearAxisFaultsPLC(final ByteBuffer data) {
        super(data);
        final String name = Axis.fromAxisNum(data.getInt()).getName();
        this.msg = new ClearAxisFaults(name);
    }

    @Override
    public void encode(final ByteBuffer data) {
        super.encode(data);
        data.putInt(Axis.fromName(msg.getAxisName()).getPLCAxisNum());
    }

    @Override
    public String toString() {
        return "ClearAxisFaultsPLC{" + super.toString() + " axis=" + msg.getAxisName() + '}';
    }
    
}
