/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.parker;

import org.lsst.ccs.drivers.parker.ProgramName;
import org.lsst.ccs.drivers.parker.ProgramUnsigned;

public enum ProgramBit {
    PROGRAM_RUNNING(1024, 32, ProgramUnsigned.PROGRAM_FLAGS, 0),
    PROGRAM_DWELLING(1025, 32, ProgramUnsigned.PROGRAM_FLAGS, 1),
    PROGRAM_INHIBITED(1026, 32, ProgramUnsigned.PROGRAM_FLAGS, 2);

    private final int base;
    private final int step;
    private final ProgramUnsigned flagParameter;
    private final long bitMask;

    private ProgramBit(int base, int step, ProgramUnsigned flagParameter, int bitIndex) {
        this.base = base;
        this.step = step;
        this.flagParameter = flagParameter;
        this.bitMask = 1L << bitIndex;
    }

    public int index(ProgramName program) {
        return this.base + program.index() * this.step;
    }

    public String reference(ProgramName program) {
        return "BIT" + this.index(program);
    }

    public ProgramUnsigned flagParameter() {
        return this.flagParameter;
    }

    public long flagParameterMask() {
        return this.bitMask;
    }
}

