/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;

public class HomeAxisPLC
extends MsgToPLC {
    private final HomeAxis msg;

    public HomeAxisPLC(HomeAxis msg) {
        this.msg = msg;
    }

    public HomeAxisPLC(ByteBuffer data) {
        super(data);
        String name = Axis.fromAxisNum((int)data.getInt()).getName();
        this.msg = new HomeAxis(name);
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        data.putInt(Axis.fromName((String)this.msg.getAxisName()).getPLCAxisNum());
    }

    public final String getAxisName() {
        return this.msg.getAxisName();
    }

    @Override
    public String toString() {
        return "HomeAxisPLC{" + super.toString() + " axis=" + this.msg.getAxisName() + "}";
    }
}

