package org.lsst.ccs.subsystem.shutter.plc;

/**
 * The possible directions of travel for the shutter. The position encoders
 * for the axes agree on direction, so that the positive direction is the same
 * for both, etc.
 */
public enum Direction {
    /**
     * Coordinate is increasing.
     */
    POSITIVE(0),

    /**
     * Coordinate is decreasing.
     */
    NEGATIVE(1);

    private int plcIndex;

    Direction(final int plcIndex) {this.plcIndex = plcIndex;}

    /**
     * Gets the array index used for direction in PLC {@code CalibDone} messages.
     * @return The index.
     * @see CalibDone
     */
    int getPlcIndex() {return plcIndex;}

}
