/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.BlackHoleChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.InSync;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleContext;
import org.lsst.ccs.subsystem.shutter.statemachine.State;
import org.lsst.ccs.subsystem.shutter.statemachine.SyncError;
import org.lsst.ccs.subsystem.shutter.statemachine.Synchronizing;

public final class TopContext
extends SimpleContext<TopContext> {
    private static final Logger LOG = Logger.getLogger(TopContext.class.getName());
    private State<TopContext> synchronizingState;
    private State<TopContext> syncErrorState;
    private State<TopContext> inSyncState;
    private boolean plcEnableFlag = false;
    private boolean brakePowerState = false;
    private String syncAlertReason = "Reason for sync error was not set.";

    public TopContext(Actions actions) {
        super(actions);
    }

    synchronized void setPLCEnabled(boolean flag) {
        this.plcEnableFlag = flag;
    }

    synchronized boolean getPLCEnabled() {
        return this.plcEnableFlag;
    }

    synchronized State<TopContext> getSynchronizingState() {
        if (this.synchronizingState == null) {
            this.synchronizingState = new Synchronizing(this);
        }
        return this.synchronizingState;
    }

    synchronized State<TopContext> getSyncErrorState() {
        if (this.syncErrorState == null) {
            this.syncErrorState = new SyncError(this);
        }
        return this.syncErrorState;
    }

    synchronized State<TopContext> getInSyncState() {
        if (this.inSyncState == null) {
            this.inSyncState = new InSync(this.getActions(), this);
        }
        return this.inSyncState;
    }

    @Override
    public void init() {
        this.makeTransition(this.getSynchronizingState(), null);
    }

    @Override
    public synchronized void brakePowerChange(Channel<EventReply> chan, boolean powerIsOn) throws InterruptedException {
        LOG.fine(() -> String.format("{EVENT brakePowerChange(powerIsOn=%s) IN TopContext}", powerIsOn));
        chan.write(PromptReply.ACCEPTED);
        boolean oldPowerState = this.brakePowerState;
        this.brakePowerState = powerIsOn;
        if (oldPowerState != powerIsOn) {
            this.getActions().publishBrakePowerStatus(this.brakePowerState);
        }
        if (oldPowerState && !this.brakePowerState) {
            this.sendBrakePowerLossEvent();
        }
    }

    void sendBrakePowerLossEvent() throws InterruptedException {
        BlackHoleChannel<EventReply> dummyChan = new BlackHoleChannel<EventReply>();
        this.getState().brakePowerLoss(dummyChan);
    }

    public synchronized boolean brakePowerIsOn() {
        return this.brakePowerState;
    }

    public synchronized String getSyncAlertReason() {
        return this.syncAlertReason;
    }

    public synchronized void setSyncAlertReason(String reason) {
        this.syncAlertReason = reason;
    }
}

