/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.CloseShutter;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.plc.OpenShutter;
import org.lsst.ccs.subsystem.shutter.plc.TakeExposure;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.DummyChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.Enabled;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Prod;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ProdTest {
    private static final Enabled dummyContext = (Enabled)Mockito.mock(Enabled.class);
    private static final MotionDonePLC[] md = new MotionDonePLC[6];
    private Prod sm;
    private Channel<EventReply> chan;
    private Actions act;

    @BeforeEach
    public void setup() {
        this.act = (Actions)Mockito.mock(Actions.class);
        this.sm = new Prod(this.act, dummyContext);
        this.chan = new DummyChannel<EventReply>();
        this.sm.init();
    }

    @Test
    public void testClosedBrakeCheck() throws InterruptedException {
        Mockito.when((Object)this.act.brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class))).thenReturn((Object)true);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CLOSED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.CLOSED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        this.sm.takeExposure(this.chan, Duration.ofSeconds(1L));
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.never())).relay((MsgToPLC)ArgumentMatchers.any());
        this.sm.openShutter(this.chan);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.never())).relay((MsgToPLC)ArgumentMatchers.any());
    }

    @Test
    public void testOpenedBrakeCheck() throws InterruptedException {
        Mockito.when((Object)this.act.brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class))).thenReturn((Object)false);
        this.sm.openShutter(this.chan);
        this.sm.motionDone(this.chan, md[0]);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CLOSED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.OPENING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.OPENED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.CLOSED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OPENING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OPENED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).relay((MsgToPLC)ArgumentMatchers.any(OpenShutter.class));
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).relay((MsgToPLC)ArgumentMatchers.any());
        Mockito.when((Object)this.act.brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class))).thenReturn((Object)true);
        this.sm.closeShutter(this.chan);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).relay((MsgToPLC)ArgumentMatchers.any());
        this.sm.timer(this.chan);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).relay((MsgToPLC)ArgumentMatchers.any());
    }

    @Test
    public void testNormalExposure() throws InterruptedException {
        Mockito.when((Object)this.act.brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class))).thenReturn((Object)false);
        Mockito.when((Object)this.act.isBadExposureTime(Duration.ofSeconds(3L))).thenReturn((Object)true);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.CLOSED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CLOSED);
        this.sm.takeExposure(this.chan, Duration.ofSeconds(1L));
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OPENING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)2))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.OPENING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)2))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.motionDone(this.chan, md[0]);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OPENED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.OPENED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.timer(this.chan);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.CLOSING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)4))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CLOSING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)4))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.motionDone(this.chan, md[1]);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.CLOSED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)5))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.CLOSED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)5))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.takeExposure(this.chan, Duration.ofSeconds(2L));
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.OPENING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)6))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.OPENING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)6))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.timer(this.chan);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.TRAVELING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)7))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.TRAVELING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)7))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.motionDone(this.chan, md[2]);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.CLOSING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)8))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.CLOSING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)8))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.motionDone(this.chan, md[3]);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.CLOSED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)9))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setSoftwareState(SoftwareState.CLOSED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)9))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.takeExposure(this.chan, Duration.ofSeconds(3L));
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)9))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)9))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.openShutter(this.chan);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.OPENING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)10))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setSoftwareState(SoftwareState.OPENING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)10))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.motionDone(this.chan, md[4]);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.OPENED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)11))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.OPENED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)11))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.closeShutter(this.chan);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setPhysicalState(PhysicalState.CLOSING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)12))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)3))).setSoftwareState(SoftwareState.CLOSING);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)12))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.motionDone(this.chan, md[5]);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)4))).setPhysicalState(PhysicalState.CLOSED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)13))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)4))).setSoftwareState(SoftwareState.CLOSED);
        ((Actions)Mockito.verify((Object)this.act, (VerificationMode)Mockito.times((int)13))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        Mockito.verifyNoInteractions((Object[])new Object[]{dummyContext});
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.act});
        ((Actions)order.verify((Object)this.act)).isBadExposureTime(Duration.ofSeconds(1L));
        ((Actions)order.verify((Object)this.act, Mockito.times((int)2))).brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class));
        ((Actions)order.verify((Object)this.act)).relay((MsgToPLC)ArgumentMatchers.any(TakeExposure.class));
        ((Actions)order.verify((Object)this.act)).sendProfile(md[0]);
        ((Actions)order.verify((Object)this.act, Mockito.times((int)2))).brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class));
        ((Actions)order.verify((Object)this.act)).sendProfile(md[1]);
        ((Actions)order.verify((Object)this.act)).isBadExposureTime(Duration.ofSeconds(2L));
        ((Actions)order.verify((Object)this.act, Mockito.times((int)2))).brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class));
        ((Actions)order.verify((Object)this.act)).relay((MsgToPLC)ArgumentMatchers.any(TakeExposure.class));
        ((Actions)order.verify((Object)this.act)).sendProfile(md[2]);
        ((Actions)order.verify((Object)this.act)).sendProfile(md[3]);
        ((Actions)order.verify((Object)this.act)).isBadExposureTime(Duration.ofSeconds(3L));
        ((Actions)order.verify((Object)this.act, Mockito.times((int)2))).brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class));
        ((Actions)order.verify((Object)this.act)).relay((MsgToPLC)ArgumentMatchers.any(OpenShutter.class));
        ((Actions)order.verify((Object)this.act)).sendProfile(md[4]);
        ((Actions)order.verify((Object)this.act, Mockito.times((int)2))).brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class));
        ((Actions)order.verify((Object)this.act)).relay((MsgToPLC)ArgumentMatchers.any(CloseShutter.class));
        ((Actions)order.verify((Object)this.act)).sendProfile(md[5]);
        ((Actions)order.verify((Object)this.act, Mockito.atLeast((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)order.verify((Object)this.act, Mockito.atLeast((int)1))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        order.verifyNoMoreInteractions();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.act});
    }

    static {
        for (int i = 0; i < 6; ++i) {
            ProdTest.md[i] = new MotionDonePLC(i, null);
        }
    }
}

