/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.PrimitiveIterator;
import java.util.stream.DoubleStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.EncoderSample;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.common.PLCError;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeAxisEnablePLC;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.ClearAllFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.ClearAxisFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.CloseShutter;
import org.lsst.ccs.subsystem.shutter.plc.Disable;
import org.lsst.ccs.subsystem.shutter.plc.DisableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.Enable;
import org.lsst.ccs.subsystem.shutter.plc.EnableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.Error;
import org.lsst.ccs.subsystem.shutter.plc.Ignored;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisAbsolutePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisRelativePLC;
import org.lsst.ccs.subsystem.shutter.plc.OpenShutter;
import org.lsst.ccs.subsystem.shutter.plc.Reset;
import org.lsst.ccs.subsystem.shutter.plc.ShutterStatusPLC;
import org.lsst.ccs.subsystem.shutter.plc.TakeExposure;
import org.lsst.ccs.subsystem.shutter.plc.Timer;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.PtpDeviceState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class codingConsistencyTest {
    private static final int BIG_ENOUGH_BUFFER_SIZE = 10240;
    private static final ByteBuffer buf = ByteBuffer.allocate(10240);

    @BeforeEach
    private void setup() {
        buf.limit(buf.capacity());
        buf.rewind();
    }

    @AfterEach
    private void teardown() {
        Assertions.assertFalse((boolean)buf.hasRemaining(), (String)"Buffer has leftover data.");
    }

    @Test
    public void testCalibDone() {
        PrimitiveIterator.OfDouble supplier = DoubleStream.iterate(0.0, x -> x + 1.0).iterator();
        CalibDone msg = new CalibDone(123, new double[]{0.0, 1.0}, new double[]{2.0, 3.0}, () -> (Double)supplier.next());
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        CalibDone msg2 = new CalibDone(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testCalibrate() {
        Calibrate msg = new Calibrate();
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Calibrate msg2 = new Calibrate(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testChangeAxisEnablePLC() {
        ChangeAxisEnablePLC msg = new ChangeAxisEnablePLC(new ChangeAxisEnable("+X", true));
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        ChangeAxisEnablePLC msg2 = new ChangeAxisEnablePLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testChangeBrakeState() {
        ChangeBrakeState msg = new ChangeBrakeState(Axis.AXIS0, ChangeBrakeState.State.RELEASED);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        ChangeBrakeState msg2 = new ChangeBrakeState(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testClearAllFaultsPLC() {
        ClearAllFaultsPLC msg = new ClearAllFaultsPLC(new ClearAllFaults());
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        ClearAllFaultsPLC msg2 = new ClearAllFaultsPLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testClearAxisFaultsPLC() {
        ClearAxisFaultsPLC msg = new ClearAxisFaultsPLC(new ClearAxisFaults("+X"));
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        ClearAxisFaultsPLC msg2 = new ClearAxisFaultsPLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testCloseShutter() {
        CloseShutter msg = new CloseShutter();
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        CloseShutter msg2 = new CloseShutter(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testDisable() {
        Disable msg = new Disable(432);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Disable msg2 = new Disable(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testDisableAllAxesPLC() {
        DisableAllAxesPLC msg = new DisableAllAxesPLC(new DisableAllAxes());
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        DisableAllAxesPLC msg2 = new DisableAllAxesPLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testEnable() {
        Enable msg = new Enable(23);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Enable msg2 = new Enable(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testEnableAllAxesPLC() {
        EnableAllAxesPLC msg = new EnableAllAxesPLC(new EnableAllAxes());
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        EnableAllAxesPLC msg2 = new EnableAllAxesPLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testError() {
        Error msg = new Error(0, EnumSet.noneOf(PLCError.class));
        Assertions.assertTrue((boolean)msg.getErrors().isEmpty());
        msg = new Error(0, EnumSet.of(PLCError.AXIS_DISABLED, PLCError.HOME_LIMIT));
        Assertions.assertEquals(EnumSet.of(PLCError.AXIS_DISABLED, PLCError.HOME_LIMIT), (Object)msg.getErrors());
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Error msg2 = new Error(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testIgnored() {
        Ignored msg = new Ignored(17, Ignored.Reason.WRONG_STATE);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Ignored msg2 = new Ignored(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
        Assertions.assertEquals((Object)Ignored.Reason.WRONG_STATE, (Object)msg.getReason());
    }

    @Test
    public void testMotionDone() {
        int i;
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        int tdai = (int)Duration.between(now.getUTCInstant(), now.getTAIInstant()).getSeconds();
        MotionDone.Builder builder = new MotionDone.Builder().side(ShutterSide.PLUSX).startTime(now).startPosition(123.0).targetDuration(Duration.ofSeconds(1L)).targetPosition(290.0).endPosition(287.0).actualDuration(Duration.ofMillis(750L)).ptpState(PtpDeviceState.SLAVE).leapSeconds(tdai).leapIsValid(true);
        for (i = 0; i < 5; ++i) {
            builder.addHallTransition(new HallTransition(now, i, (double)i * 20.0, true));
        }
        for (i = 0; i < 10; ++i) {
            builder.addEncoderSample(new EncoderSample(now, (double)i * 10.0));
        }
        MotionDone motion = builder.build();
        Assertions.assertFalse((boolean)motion.isDummy());
        builder.hallTransitions(Collections.emptyList());
        builder.encoderSamples(Collections.emptyList());
        builder.ptpState(PtpDeviceState.SLAVE).leapSeconds(tdai).leapIsValid(true);
        MotionDone dummyMotion = builder.build();
        Assertions.assertTrue((boolean)dummyMotion.isDummy());
        MotionDonePLC msg = new MotionDonePLC(104, motion);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        MotionDonePLC msg2 = new MotionDonePLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testMoveAxisAbsolutePLC() {
        MoveAxisAbsolutePLC msg = new MoveAxisAbsolutePLC(new MoveAxisAbsolute("-X", 123.2, 15.7));
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        MoveAxisAbsolutePLC msg2 = new MoveAxisAbsolutePLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testMoveAxisRelativePLC() {
        MoveAxisRelativePLC msg = new MoveAxisRelativePLC(new MoveAxisRelative("+X", -15.3, Duration.ofMillis(2500L)));
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        MoveAxisRelativePLC msg2 = new MoveAxisRelativePLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testOpenShutter() {
        OpenShutter msg = new OpenShutter();
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        OpenShutter msg2 = new OpenShutter(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testReset() {
        Reset msg = new Reset(12345.0);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Reset msg2 = new Reset(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testShutterStatus() {
        EnumMap<ShutterSide, ShutterStatusPLC.AxisStatusPLC> axes = new EnumMap<ShutterSide, ShutterStatusPLC.AxisStatusPLC>(ShutterSide.class);
        axes.put(ShutterSide.PLUSX, new ShutterStatusPLC.AxisStatusPLC(1.1, 2.2, 3.3, true, false, true, false, true, 15, 110.0));
        axes.put(ShutterSide.MINUSX, new ShutterStatusPLC.AxisStatusPLC(4.4, 5.5, 6.6, false, true, false, true, false, 13, 98.6));
        ShutterStatusPLC msg = new ShutterStatusPLC(0, 1, true, 0, axes, true, Arrays.asList(0, 0, 0), 0L, PtpDeviceState.toStateNumber((PtpDeviceState)PtpDeviceState.SLAVE), 0, false);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        ShutterStatusPLC msg2 = new ShutterStatusPLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testTakeExposure() {
        TakeExposure msg = new TakeExposure(Duration.ofMillis(22123L));
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        TakeExposure msg2 = new TakeExposure(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testTimer() {
        Timer msg = new Timer(5);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Timer msg2 = new Timer(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }
}

