package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEntry;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEvent;
import static org.lsst.ccs.subsystem.shutter.statemachine.PromptReply.ACCEPTED;

/**
 * The state in the second of two blade sets is being centered in prep for power-off.
 * Thread-safe.
 * @author tether
 */
class Centering2 extends SimpleState<Maint> {
    private static final Logger LOG = Logger.getLogger(Centering2.class.getName());

    /**
     * Saves the context for this state.
     * @param context The context.
     * @throws NullPointerException if the context is null.
     */
    public Centering2(final Maint context) {
        super(context);
    }

    @Override
    public void entry() {
        logEntry(this);
        getContext().getActions().setSoftwareState(SoftwareState.CENTERING2);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void brakePowerLoss(final Channel<EventReply> chan) throws InterruptedException {
        logEvent(this);
        chan.write(ACCEPTED);
        getContext().getActions().signalAReset();
    }

    @Override
    public void motionDone(final Channel<EventReply> chan, final MotionDonePLC profileData) throws InterruptedException {
        logEvent(this);
        chan.write(ACCEPTED);
        final Maint ctx = getContext();
        final Actions act = ctx.getActions();
        ctx.makeTransition(
            ctx.getStillState(),
            () -> {act.sendProfile(profileData); act.setPhysicalState(PhysicalState.CENTERED);}
        );
    }

}
