/**
 * This package implements the conversion of messages that are sent and received from the
 * Beckhoff PLC controller via ADS. Most of the classes represent messages and inherit from one of
 * two abstract classes:
 * <ul>
 * <li>PLCMsg defines the version number associated with the entire set of messages
 * and provides an instance fields to hold it. Messages sent from the PLC to the CCS subsystem
 * inherit directly from it.</li>
 * <li>MsgToPLC inherits from PLCMsg and is the base class for all messages sent from CCS to PLC.
 * It provides fields containing the message identification information that the PLC
 * code requires in order to detect when a new message of the given type has arrived.
 * It also contains the message sequence counter and the UUID for the subsystem.</li>
 * </ul>
 * <p>
 * Every message class has a constructor that can decode the PLC (ADS) form of the message and set
 * the instance fields accordingly. Each also has an encode() method which implements the reverse
 * transformation. Neither the constructor nor encode() resets the current position of the
 * byte buffers used to hold the PLC form of the message. Both the decoding constructor and the
 * encoding method are provided in order to facilitate testing; in normal use either one or the other
 * is used. For the same reason each message class also has a constructor that takes
 * the values of instance fields directly if there are any.
 * <p>
 * See <a href="https://docs.google.com/document/d/1k-oAwnY8rhwuz5pN1PkQU-riK-ZKio4tmEnwgZLlOFM">
 * the subsystem manual</a>
 * for a more detailed description of the communication between the subsystem and the PLC controller.
 */
package org.lsst.ccs.subsystem.shutter.plc;
