/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.statemachine.BlackHoleChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SynchronousChannel;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class Watchdog
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(Watchdog.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile StateMachine centralSm;
    @ConfigurationParameter(description="The interval between checks of the PLC  message counter.", units="s")
    private volatile Duration checkInterval;
    private final SynchronousChannel<Runnable> inChannel = new SynchronousChannel();
    private final Scheduler sched;
    private int msgCount = 0;
    private WatchState state = WatchState.DISABLED;

    public Watchdog() {
        this.sched = new Scheduler("PLCWatchdog", 3);
        this.checkInterval = Duration.ofSeconds(10L);
    }

    public void start() {
        this.startWatchdogTask();
        this.startTimerTask();
    }

    private void startWatchdogTask() {
        this.sched.schedule(this::watchdogBody, 0L, TimeUnit.MILLISECONDS);
    }

    private void startTimerTask() {
        this.sched.scheduleWithFixedDelay(this::timerBody, 100L, this.checkInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void startSenderTask() {
        this.sched.schedule(this::senderBody, 0L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.sched.shutdownNow();
    }

    public void enable() throws InterruptedException {
        this.inChannel.write(this::enableImpl);
    }

    public void disable() throws InterruptedException {
        this.inChannel.write(this::disableImpl);
    }

    public void countMessage() throws InterruptedException {
        this.inChannel.write(this::countImpl);
    }

    public void checkMessageCount() throws InterruptedException {
        this.inChannel.write(this::checkImpl);
    }

    private synchronized void enableImpl() {
        if (this.state == WatchState.DISABLED) {
            this.state = WatchState.ENABLED;
        }
    }

    private synchronized void disableImpl() {
        if (this.state == WatchState.ENABLED) {
            this.state = WatchState.DISABLED;
            this.msgCount = 0;
        }
    }

    private synchronized void countImpl() {
        if (this.state == WatchState.ENABLED) {
            ++this.msgCount;
        }
    }

    private synchronized void checkImpl() {
        if (this.state == WatchState.ENABLED) {
            if (this.msgCount == 0) {
                this.startSenderTask();
            } else {
                this.msgCount = 0;
            }
        }
    }

    private void watchdogBody() {
        try {
            Thread.currentThread().setName("Watchdog main task");
            LOG.info("Starting the PLC message watchdog main task.");
            while (true) {
                this.inChannel.read().run();
            }
        }
        catch (InterruptedException exc) {
            LOG.info("Normal exit of the PLC message watchdog.");
        }
        catch (Exception exc) {
            LOG.log(Level.SEVERE, "Exception in watchdog task. Restarting.", exc);
            this.startWatchdogTask();
        }
    }

    private void timerBody() {
        try {
            Thread.currentThread().setName("Watchdog timer task");
            this.checkMessageCount();
        }
        catch (InterruptedException exc) {
            LOG.info("The PLC message watchdog timer was interrupted!");
        }
        catch (Exception exc) {
            LOG.log(Level.SEVERE, "Exception in the watchdog timer task.", exc);
        }
    }

    private void senderBody() {
        BlackHoleChannel<EventReply> chan = new BlackHoleChannel<EventReply>();
        try {
            Thread.currentThread().setName("Watchdog contactLost()-sender task");
            this.centralSm.contactLost(chan, "No messages are coming in from the shutter PLC.");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static enum WatchState {
        ENABLED,
        DISABLED;

    }
}

