/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;

public enum Alerts {
    SYNC(new Alert("SYNC", "Status of tracking of controller state.")),
    PLC(new Alert("PLC", "Notice of errors from shutter controller.")),
    MOTION(new Alert("MOTION", "Check of motion profile using Hall data.")),
    MOTOR(new Alert("MOTOR", "A problem with the motors.")),
    STOP_CMD(new Alert("STOP_CMD", "Received the stopAllMotion() command while in the Prod superstate."));

    private final Alert ccsAlert;

    private Alerts(Alert ccsAlert) {
        this.ccsAlert = ccsAlert;
    }

    public void raise(AlertService alertSvc, AlertState severity, String cause, AlertService.RaiseAlertStrategy strategy) {
        alertSvc.raiseAlert(this.ccsAlert, severity, cause, strategy);
    }

    public static void registerAll(AlertService alertSvc) {
        for (Alerts a : Alerts.values()) {
            alertSvc.registerAlert(a.ccsAlert, AlertService.ALWAYS);
        }
    }
}

