/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@Experimental
@MBean(description="Protocol just above the transport which disseminates multicasts via daisy chaining")
public class DAISYCHAIN
extends Protocol {
    @Property(description="Loop back multicast messages")
    boolean loopback = true;
    protected volatile Address local_addr;
    protected volatile Address next;
    protected int view_size = 0;
    protected Executor default_pool = null;
    protected volatile boolean running = true;
    @ManagedAttribute
    public int msgs_forwarded = 0;
    @ManagedAttribute
    public int msgs_sent = 0;

    @Override
    public void resetStats() {
        super.resetStats();
        this.msgs_sent = 0;
        this.msgs_forwarded = 0;
    }

    @Override
    public void init() throws Exception {
        this.default_pool = this.getTransport().getThreadPool();
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.running = true;
    }

    @Override
    public void stop() {
        super.stop();
        this.running = false;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
                break;
            }
            case 15: {
                this.view_size = ((View)evt.getArg()).size();
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        if (msg.getDest() != null) {
            return this.down_prot.down(msg);
        }
        if (this.next == null) {
            return this.down_prot.down(msg);
        }
        Message copy = msg.copy(true);
        short hdr_ttl = (short)(this.loopback ? this.view_size - 1 : this.view_size);
        DaisyHeader hdr = new DaisyHeader(hdr_ttl);
        copy.setDest(this.next);
        copy.putHeader(this.getId(), hdr);
        ++this.msgs_sent;
        if (this.loopback) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(new StringBuilder("looping back message ").append(msg));
            }
            if (msg.getSrc() == null) {
                msg.setSrc(this.local_addr);
            }
            this.default_pool.execute(() -> this.up_prot.up(msg));
        }
        return this.down_prot.down(copy);
    }

    @Override
    public Object up(Message msg) {
        DaisyHeader hdr = (DaisyHeader)msg.getHeader(this.getId());
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        short ttl = hdr.getTTL();
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": received message from " + msg.getSrc() + " with ttl=" + ttl);
        }
        if ((ttl = (short)(ttl - 1)) > 0) {
            Message copy = msg.copy(true);
            copy.setDest(this.next);
            copy.putHeader(this.getId(), new DaisyHeader(ttl));
            ++this.msgs_forwarded;
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": forwarding message to " + this.next + " with ttl=" + ttl);
            }
            this.down_prot.down(copy);
        }
        msg.setDest(null);
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            DaisyHeader hdr = (DaisyHeader)msg.getHeader(this.getId());
            if (hdr == null) continue;
            short ttl = hdr.getTTL();
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": received message from " + msg.getSrc() + " with ttl=" + ttl);
            }
            if ((ttl = (short)(ttl - 1)) > 0) {
                Message copy = msg.copy(true);
                copy.setDest(this.next);
                copy.putHeader(this.getId(), new DaisyHeader(ttl));
                ++this.msgs_forwarded;
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + ": forwarding message to " + this.next + " with ttl=" + ttl);
                }
                this.down_prot.down(copy);
            }
            msg.setDest(null);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleView(View view) {
        this.view_size = view.size();
        Address tmp = Util.pickNext(view.getMembers(), this.local_addr);
        if (tmp != null && !tmp.equals(this.local_addr)) {
            this.next = tmp;
            if (this.log.isDebugEnabled()) {
                this.log.debug("next=" + this.next);
            }
        }
    }

    public static class DaisyHeader
    extends Header {
        private short ttl;

        public DaisyHeader() {
        }

        public DaisyHeader(short ttl) {
            this.ttl = ttl;
        }

        @Override
        public short getMagicId() {
            return 69;
        }

        public short getTTL() {
            return this.ttl;
        }

        public void setTTL(short ttl) {
            this.ttl = ttl;
        }

        @Override
        public Supplier<? extends Header> create() {
            return DaisyHeader::new;
        }

        @Override
        public int serializedSize() {
            return 2;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeShort(this.ttl);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.ttl = in.readShort();
        }

        @Override
        public String toString() {
            return "ttl=" + this.ttl;
        }
    }
}

