/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.common.service.DataAccumulationService;

public class PersistentCounter {
    private final String path;
    private final Subsystem subsys;
    private final DataAccumulationService accumSvc;

    private PersistentCounter(String path, Subsystem subsys) {
        this.path = path;
        this.subsys = subsys;
        this.accumSvc = (DataAccumulationService)subsys.getAgentService(DataAccumulationService.class);
    }

    private void register() {
        DataProviderDictionaryService dataSvc = (DataProviderDictionaryService)this.subsys.getAgentService(DataProviderDictionaryService.class);
        dataSvc.registerData(new KeyValueData(this.path, (Serializable)Double.valueOf(0.0)));
        this.accumSvc.registerAccumulatedDataPath(this.path);
    }

    public static PersistentCounter newCounter(String path, Subsystem subsys) {
        PersistentCounter ctr = new PersistentCounter(path, subsys);
        ctr.register();
        return ctr;
    }

    public void increment(double inc) {
        ((DataAccumulationService)this.subsys.getAgentService(DataAccumulationService.class)).accumulateData(this.path, inc);
        double sum = this.getValue();
        if (!Double.isNaN(sum)) {
            this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)Double.valueOf(sum)));
        }
    }

    public double getValue() {
        return this.accumSvc.getAccumulatedValueForPath(this.path);
    }
}

