/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.Context;
import org.lsst.ccs.subsystem.shutter.statemachine.DummyChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleContext;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;
import org.lsst.ccs.subsystem.shutter.statemachine.State;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class SimpleContextTest {
    @Test
    public void testTransitions() throws InterruptedException {
        Ctx sm = new Ctx();
        DummyChannel chan = new DummyChannel();
        sm.init();
        sm.enable(chan);
        sm.disable(chan);
        Actions act = sm.getActions();
        InOrder order = Mockito.inOrder((Object[])new Object[]{act});
        ((Actions)order.verify((Object)act)).raiseSyncAlert();
        ((Actions)order.verify((Object)act)).resetPLC();
        ((Actions)order.verify((Object)act)).relay(null);
        ((Actions)order.verify((Object)act)).saveCalib(null);
        ((Actions)order.verify((Object)act)).sendProfile(null);
        ((Actions)order.verify((Object)act)).raiseSyncAlert();
        order.verifyNoMoreInteractions();
    }

    private static class Ctx
    extends SimpleContext<Ctx> {
        private State<Ctx> stateA;
        private State<Ctx> stateB;

        public Ctx() {
            super((Actions)Mockito.mock(Actions.class));
        }

        public void init() {
            this.makeTransition(this.getStateA(), null);
        }

        synchronized State<Ctx> getStateA() {
            if (this.stateA == null) {
                this.stateA = new StateA(this);
            }
            return this.stateA;
        }

        synchronized State<Ctx> getStateB() {
            if (this.stateB == null) {
                this.stateB = new StateB(this);
            }
            return this.stateB;
        }
    }

    private static class StateB
    extends SimpleState<Ctx> {
        public StateB(Ctx context) {
            super((Context)context);
        }

        public Logger getLogger() {
            return null;
        }

        public void entry() {
            ((Ctx)this.getContext()).getActions().relay(null);
        }

        public void exit() {
            ((Ctx)this.getContext()).getActions().saveCalib(null);
        }

        public void disable(Channel<EventReply> chan) throws InterruptedException {
            chan.write((Object)PromptReply.ACCEPTED);
            ((Ctx)this.getContext()).makeTransition(((Ctx)this.getContext()).getStateA(), () -> ((Ctx)this.getContext()).getActions().sendProfile(null));
        }
    }

    private static class StateA
    extends SimpleState<Ctx> {
        public StateA(Ctx context) {
            super((Context)context);
        }

        public Logger getLogger() {
            return null;
        }

        public void entry() {
            ((Ctx)this.getContext()).getActions().raiseSyncAlert();
        }

        public void exit() {
        }

        public void enable(Channel<EventReply> chan) throws InterruptedException {
            chan.write((Object)PromptReply.ACCEPTED);
            ((Ctx)this.getContext()).makeTransition(((Ctx)this.getContext()).getStateB(), () -> ((Ctx)this.getContext()).getActions().resetPLC());
        }
    }
}

