package org.lsst.ccs.subsystem.shutter.plc;

import org.lsst.ccs.subsystem.shutter.common.Axis;
import java.nio.ByteBuffer;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;

/**
 * Signals the PLC to change the enable state of an axis.
 * @author tether
 */
public class ChangeAxisEnablePLC extends MsgToPLC {
    
    private ChangeAxisEnable msg;

    /**
     * Constructs using an instance of the motorplatform message.
     * @param msg Supplies data specific to this type of message.
     * @see ChangeAxisEnable
     */
    public ChangeAxisEnablePLC(final ChangeAxisEnable msg) {
        this.msg = msg;
    }

    /**
     * Reads and converts the PLC form of the message.
     * @param data The PLC message data buffer.
     */
    public ChangeAxisEnablePLC(final ByteBuffer data) {
        super(data);
        final String name = Axis.fromAxisNum(data.getInt()).getName();
        final boolean enable = data.get() != 0;
        this.msg = new ChangeAxisEnable(name, enable);
    }
    
    @Override
    public void encode(final ByteBuffer data) {
        super.encode(data);
        data.putInt(Axis.fromName(msg.getAxisName()).getPLCAxisNum());
        data.put((byte)(msg.isEnabled() ? 1 : 0));
    }

    @Override
    public String toString() {
        return "ChangeAxisEnablePLC{" +
               super.toString() +
               " axis=" + msg.getAxisName() +
               ", enabled=" + msg.isEnabled() + '}';
    }
    

}
