/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.Controller;
import org.lsst.ccs.subsystem.shutter.Publisher;
import org.lsst.ccs.subsystem.shutter.RealActions;
import org.lsst.ccs.subsystem.shutter.SimulatedActions;
import org.lsst.ccs.subsystem.shutter.Watchdog;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.Error;
import org.lsst.ccs.subsystem.shutter.plc.Ignored;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.BlackHoleChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Events;
import org.lsst.ccs.subsystem.shutter.statemachine.SynchronousChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.TopContext;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class StateMachine
implements HasLifecycle,
Events {
    private static final Logger LOG = Logger.getLogger(StateMachine.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Controller controller;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Publisher publish;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Watchdog wdog;
    @ConfigurationParameter(description="How long to delay restarting a crashed long-running task.", units="s")
    private volatile Duration taskRestartDelay = Duration.ofMillis(10L);
    @ConfigurationParameter(description="Wait this long for the shutter to enter Still or Disabled after a reset.", units="s")
    private volatile Duration resetSyncTimeout = Duration.ofSeconds(10L);
    private final Channel<Callable<Void>> eventChan = new SynchronousChannel<Callable<Void>>();
    private final Scheduler taskScheduler = new Scheduler("StateMachine tasks", 10);
    private volatile PeriodicTask eventTask;
    private volatile ScheduledFuture<?> syncTimeoutTask;
    private volatile TopContext internalMachine;
    private volatile Actions actions;
    private static final int THREAD_POOL_SIZE = 10;

    public StateMachine() {
        this.taskScheduler.setLogger(LOG);
        this.taskScheduler.setDefaultLogLevel(Level.SEVERE);
    }

    public void init() {
        AgentStateService stateServ = (AgentStateService)this.subsys.getAgentService(AgentStateService.class);
        stateServ.registerState(PhysicalState.class, "The physical state of the shutter", (Object)this);
        stateServ.updateAgentComponentState((Object)this, new Enum[]{PhysicalState.OTHER});
        stateServ.registerState(SoftwareState.class, "The state of the subsystem's central state machine", (Object)this);
        stateServ.updateAgentComponentState((Object)this, new Enum[]{SoftwareState.SYNCHRONIZING});
    }

    public void postStart() {
        if (RunMode.isSimulation()) {
            this.actions = new SimulatedActions(this.controller, this, this.subsys, this.publish, this.wdog);
            this.internalMachine = new TopContext(this.actions);
        } else {
            this.actions = new RealActions(this.controller, this, this.subsys, this.publish, this.wdog);
            this.internalMachine = new TopContext(this.actions);
        }
        this.internalMachine.init();
        this.eventTask = this.taskScheduler.scheduleWithFixedDelay(this::eventTaskBody, 0L, this.taskRestartDelay.toMillis(), TimeUnit.MILLISECONDS);
        if (RunMode.isSimulation()) {
            try {
                SynchronousChannel<EventReply> replyChan = new SynchronousChannel<EventReply>();
                this.plcIsEnabled(replyChan);
                replyChan.read();
                this.gotoProd(replyChan);
                replyChan.read();
            }
            catch (InterruptedException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
        }
    }

    public Actions getActions() {
        return this.actions;
    }

    private void eventTaskBody() {
        LOG.info("The event task has started.");
        try {
            while (true) {
                LOG.fine("About to read an event.");
                Callable<Void> event = this.eventChan.read();
                LOG.fine("Running an event.");
                event.call();
            }
        }
        catch (InterruptedException exc) {
            LOG.info("Normal stop of the event task.");
        }
        catch (Exception exc) {
            LOG.log(Level.WARNING, "Exception thrown in the internal state machine.", exc);
        }
    }

    public void shutdown() {
        this.taskScheduler.shutdownNow();
    }

    @Override
    public void brakePowerChange(Channel<EventReply> replyChan, boolean isPowerOn) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.brakePowerChange(replyChan, isPowerOn);
            return null;
        });
    }

    @Override
    public void brakePowerLoss(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.brakePowerLoss(replyChan);
            return null;
        });
    }

    @Override
    public void contactLost(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.contactLost(replyChan);
            return null;
        });
    }

    @Override
    public void plcIsEnabled(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.plcIsEnabled(replyChan);
            return null;
        });
    }

    @Override
    public void plcIsDisabled(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.plcIsDisabled(replyChan);
            return null;
        });
    }

    @Override
    public void resync(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.resync(replyChan);
            return null;
        });
    }

    @Override
    public void syncTimeout(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.syncTimeout(replyChan);
            return null;
        });
    }

    @Override
    public void enable(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.enable(replyChan);
            return null;
        });
    }

    @Override
    public void disable(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.disable(replyChan);
            return null;
        });
    }

    @Override
    public void motionDone(Channel<EventReply> replyChan, MotionDonePLC profileData) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.motionDone(replyChan, profileData);
            return null;
        });
    }

    @Override
    public void calibrate(Channel<EventReply> replyChan, Calibrate calibParams) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.calibrate(replyChan, calibParams);
            return null;
        });
    }

    @Override
    public void toggleSafetyCheck(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.toggleSafetyCheck(replyChan);
            return null;
        });
    }

    @Override
    public void calibDone(Channel<EventReply> replyChan, CalibDone calibResults) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.calibDone(replyChan, calibResults);
            return null;
        });
    }

    @Override
    public void error(Channel<EventReply> replyChan, Error err) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.error(replyChan, err);
            return null;
        });
    }

    @Override
    public void reset(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.reset(replyChan);
            return null;
        });
    }

    @Override
    public void takeExposure(Channel<EventReply> replyChan, Duration exposureTime) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.takeExposure(replyChan, exposureTime);
            return null;
        });
    }

    @Override
    public void openShutter(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.openShutter(replyChan);
            return null;
        });
    }

    @Override
    public void timer(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.timer(replyChan);
            return null;
        });
    }

    @Override
    public void closeShutter(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.closeShutter(replyChan);
            return null;
        });
    }

    @Override
    public void ignored(Channel<EventReply> replyChan, Ignored.Reason reason) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.ignored(replyChan, reason);
            return null;
        });
    }

    @Override
    public void gotoProd(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.gotoProd(replyChan);
            return null;
        });
    }

    @Override
    public void gotoCenter(Channel<EventReply> replyChan) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.gotoCenter(replyChan);
            return null;
        });
    }

    @Override
    public void moveAxisAbsolute(Channel<EventReply> replyChan, MoveAxisAbsolute req) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.moveAxisAbsolute(replyChan, req);
            return null;
        });
    }

    @Override
    public void moveAxisRelative(Channel<EventReply> replyChan, MoveAxisRelative req) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.moveAxisRelative(replyChan, req);
            return null;
        });
    }

    @Override
    public void clearAllFaults(Channel<EventReply> replyChan, ClearAllFaults req) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.clearAllFaults(replyChan, req);
            return null;
        });
    }

    @Override
    public void changeAxisEnable(Channel<EventReply> replyChan, ChangeAxisEnable req) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.changeAxisEnable(replyChan, req);
            return null;
        });
    }

    @Override
    public void changeBrakeState(Channel<EventReply> replyChan, Axis ax, ChangeBrakeState.State newState) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.changeBrakeState(replyChan, ax, newState);
            return null;
        });
    }

    @Override
    public void clearAxisFaults(Channel<EventReply> replyChan, ClearAxisFaults req) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.clearAxisFaults(replyChan, req);
            return null;
        });
    }

    @Override
    public void enableAllAxes(Channel<EventReply> replyChan, EnableAllAxes req) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.enableAllAxes(replyChan, req);
            return null;
        });
    }

    @Override
    public void disableAllAxes(Channel<EventReply> replyChan, DisableAllAxes req) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.disableAllAxes(replyChan, req);
            return null;
        });
    }

    @Override
    public void homeAxis(Channel<EventReply> replyChan, HomeAxis req) throws InterruptedException {
        this.eventChan.write(() -> {
            this.internalMachine.homeAxis(replyChan, req);
            return null;
        });
    }

    boolean brakePowerIsOn() {
        return this.internalMachine.brakePowerIsOn();
    }

    void setPhysicalState(PhysicalState newState) {
        AgentStateService stateServ = (AgentStateService)this.subsys.getAgentService(AgentStateService.class);
        stateServ.updateAgentComponentState((Object)this, new Enum[]{newState});
    }

    void setSoftwareState(SoftwareState newState) {
        AgentStateService stateServ = (AgentStateService)this.subsys.getAgentService(AgentStateService.class);
        stateServ.updateAgentComponentState((Object)this, new Enum[]{newState});
    }

    synchronized void startSyncTimer() {
        BlackHoleChannel chan = new BlackHoleChannel();
        Callable<Void> snippet = () -> {
            this.syncTimeout(chan);
            return null;
        };
        this.syncTimeoutTask = this.taskScheduler.schedule(snippet, this.resetSyncTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    synchronized void cancelSyncTimer() {
        if (this.syncTimeoutTask != null) {
            this.syncTimeoutTask.cancel(true);
        }
    }
}

