/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeAxisEnablePLC;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.ClearAllFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.ClearAxisFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.DisableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.EnableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisAbsolutePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisRelativePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.DummyChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.Enabled;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Maint;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MaintTest {
    private static final Enabled dummyContext = (Enabled)Mockito.mock(Enabled.class);
    private static final MoveAxisAbsolute absMove = new MoveAxisAbsolute(Axis.AXIS0.getName(), 0.0, 100.0);
    private static final MoveAxisAbsolutePLC absMovePlc = new MoveAxisAbsolutePLC(absMove);
    private static final MoveAxisRelative relMove = new MoveAxisRelative(Axis.AXIS0.getName(), 100.0, Duration.ofSeconds(10L));
    private static final MoveAxisRelativePLC relMovePlc = new MoveAxisRelativePLC(relMove);
    private Maint sm;
    private Channel<EventReply> chan;
    private Actions mockActions;

    @BeforeEach
    public void setup() {
        this.mockActions = (Actions)Mockito.mock(Actions.class);
        this.sm = new Maint(this.mockActions, dummyContext);
        this.chan = new DummyChannel<EventReply>();
        this.sm.init();
    }

    @Test
    public void testNonMotionEvents() throws InterruptedException {
        this.sm.changeAxisEnable(this.chan, new ChangeAxisEnable(Axis.AXIS0.getName(), true));
        this.sm.clearAllFaults(this.chan, new ClearAllFaults());
        this.sm.clearAxisFaults(this.chan, new ClearAxisFaults(Axis.AXIS0.getName()));
        Mockito.when((Object)this.mockActions.brakeIsEngaged(ShutterSide.MINUSX)).thenReturn((Object)false, (Object[])new Boolean[]{true});
        Mockito.when((Object)this.mockActions.brakeIsEngaged(ShutterSide.PLUSX)).thenReturn((Object)true, (Object[])new Boolean[]{true});
        this.sm.disableAllAxes(this.chan, new DisableAllAxes());
        this.sm.disableAllAxes(this.chan, new DisableAllAxes());
        this.sm.enableAllAxes(this.chan, new EnableAllAxes());
        Mockito.when((Object)this.mockActions.brakePowerIsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.mockActions.axisIsEnabled((ShutterSide)ArgumentMatchers.any(ShutterSide.class))).thenReturn((Object)false, (Object[])new Boolean[]{true});
        this.sm.changeBrakeState(this.chan, Axis.AXIS0, ChangeBrakeState.State.RELEASED);
        this.sm.changeBrakeState(this.chan, Axis.AXIS0, ChangeBrakeState.State.RELEASED);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.never())).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)2))).brakePowerIsOn();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.mockActions});
        ((Actions)order.verify((Object)this.mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ChangeAxisEnablePLC.class));
        ((Actions)order.verify((Object)this.mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ClearAllFaultsPLC.class));
        ((Actions)order.verify((Object)this.mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ClearAxisFaultsPLC.class));
        ((Actions)order.verify((Object)this.mockActions)).relay((MsgToPLC)ArgumentMatchers.any(DisableAllAxesPLC.class));
        ((Actions)order.verify((Object)this.mockActions)).relay((MsgToPLC)ArgumentMatchers.any(EnableAllAxesPLC.class));
        ((Actions)order.verify((Object)this.mockActions)).relay((MsgToPLC)ArgumentMatchers.any(ChangeBrakeState.class));
        order.verifyNoMoreInteractions();
    }

    @Test
    public void testBrakePowerOff() throws InterruptedException {
        Mockito.when((Object)this.mockActions.brakePowerIsOn()).thenReturn((Object)false);
        this.sm.changeBrakeState(this.chan, Axis.AXIS0, ChangeBrakeState.State.RELEASED);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.never())).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).brakePowerIsOn();
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.never())).relay((MsgToPLC)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockActions});
    }

    @Test
    public void testAbsoluteMotionNoBrakes() throws InterruptedException {
        Mockito.when((Object)this.mockActions.brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class))).thenReturn((Object)false);
        this.sm.moveAxisAbsolute(this.chan, absMove);
        this.finishMotion(this.chan, false, (MsgToPLC)absMovePlc);
    }

    @Test
    public void testAbsoluteMotionWithBrakes() throws InterruptedException {
        Mockito.when((Object)this.mockActions.brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class))).thenReturn((Object)true);
        this.sm.moveAxisAbsolute(this.chan, absMove);
        this.finishMotion(this.chan, true, (MsgToPLC)absMovePlc);
    }

    @Test
    public void testRelativeMotionNoBrakes() throws InterruptedException {
        Mockito.when((Object)this.mockActions.brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class))).thenReturn((Object)false);
        this.sm.moveAxisRelative(this.chan, relMove);
        this.finishMotion(this.chan, false, (MsgToPLC)relMovePlc);
    }

    @Test
    public void testRelativeMotionWithBrakes() throws InterruptedException {
        Mockito.when((Object)this.mockActions.brakeIsEngaged((ShutterSide)ArgumentMatchers.any(ShutterSide.class))).thenReturn((Object)true);
        this.sm.moveAxisRelative(this.chan, relMove);
        this.finishMotion(this.chan, true, (MsgToPLC)relMovePlc);
    }

    private void finishMotion(Channel<EventReply> chan, boolean brakesAreSet, MsgToPLC toPlc) throws InterruptedException {
        if (brakesAreSet) {
            ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.never())).setPhysicalState((PhysicalState)ArgumentMatchers.any());
            ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.STILL);
        } else {
            ((Actions)Mockito.verify((Object)this.mockActions)).setPhysicalState(PhysicalState.ENG_MOVING);
            ((Actions)Mockito.verify((Object)this.mockActions)).setPhysicalState((PhysicalState)ArgumentMatchers.any());
            ((Actions)Mockito.verify((Object)this.mockActions)).setSoftwareState(SoftwareState.MOVING);
            ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
            MotionDonePLC md1 = (MotionDonePLC)Mockito.mock(MotionDonePLC.class);
            this.sm.motionDone(chan, md1);
            ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OTHER);
            ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
            ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.STILL);
            ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)3))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
            InOrder order = Mockito.inOrder((Object[])new Object[]{this.mockActions});
            ((Actions)order.verify((Object)this.mockActions)).relay((MsgToPLC)ArgumentMatchers.any(toPlc.getClass()));
            ((Actions)order.verify((Object)this.mockActions)).sendProfile(md1);
        }
    }

    @Test
    public void testCalibration() throws InterruptedException {
        Mockito.when((Object)this.mockActions.readyForCalibration()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        this.sm.calibrate(this.chan, (Calibrate)Mockito.mock(Calibrate.class));
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.never())).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.never())).setSoftwareState(SoftwareState.CALIBRATING);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.calibrate(this.chan, (Calibrate)Mockito.mock(Calibrate.class));
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CALIBRATING);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        this.sm.calibDone(this.chan, (CalibDone)Mockito.mock(CalibDone.class));
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OTHER);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CALIBRATING);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)3))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.mockActions});
        ((Actions)order.verify((Object)this.mockActions)).relay((MsgToPLC)ArgumentMatchers.any(Calibrate.class));
        ((Actions)order.verify((Object)this.mockActions)).saveCalib((CalibDone)ArgumentMatchers.any(CalibDone.class));
    }

    @Test
    public void testCentering() throws InterruptedException {
        this.sm.gotoCenter(this.chan);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.ENG_MOVING);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CENTERING1);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        MotionDonePLC md3 = (MotionDonePLC)Mockito.mock(MotionDonePLC.class);
        this.sm.motionDone(this.chan, md3);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.CENTERING2);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)3))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        MotionDonePLC md4 = (MotionDonePLC)Mockito.mock(MotionDonePLC.class);
        this.sm.motionDone(this.chan, md4);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.CENTERED);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)this.mockActions, (VerificationMode)Mockito.times((int)4))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.mockActions});
        ((Actions)order.verify((Object)this.mockActions)).startFirstCentering();
        ((Actions)order.verify((Object)this.mockActions)).sendProfile(md3);
        ((Actions)order.verify((Object)this.mockActions)).startSecondCentering();
        ((Actions)order.verify((Object)this.mockActions)).sendProfile(md4);
        ((Actions)order.verify((Object)this.mockActions, Mockito.atLeast((int)1))).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)order.verify((Object)this.mockActions, Mockito.atLeast((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        order.verifyNoMoreInteractions();
    }
}

