package org.lsst.ccs.subsystem.shutter.plc;

import org.lsst.ccs.subsystem.shutter.common.Axis;
import java.nio.ByteBuffer;
import java.time.Duration;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;

/**
 * Signals the PLC to move one axis to a given distance from its current coordinate
 * at the time the command is actually executed.
 * @author tether
 */
public class MoveAxisRelativePLC extends MsgToPLC {
    
    private final MoveAxisRelative msg;

    /**
     * Constructs using an instance of the motorplatform message.
     * @param msg Holds the message-specific data.
     */
    public MoveAxisRelativePLC(final MoveAxisRelative msg) {
        this.msg = msg;
    }

    /**
     * Reads and converts the PLC form of the message.
     * @param data Hold the PLC message data.
     */
    public MoveAxisRelativePLC(final ByteBuffer data) {
        super(data);
        final int index = data.getInt();
        final double dist = data.getDouble();
        final int millis = data.getInt();
        this.msg = 
            new MoveAxisRelative(
                    Axis.fromAxisNum(index).getName(),
                    dist,
                    Duration.ofMillis(millis));
    }

    @Override
    public void encode(final ByteBuffer data) {
        super.encode(data);
        data.putInt(Axis.fromName(msg.getAxisName()).getPLCAxisNum());
        data.putDouble(msg.getDistance());
        data.putInt((int)msg.getTime().toMillis());
    }

    @Override
    public String toString() {
        return "MoveAxisRelativePLC{" + super.toString() +
               " axis=" + msg.getAxisName() +
               ", distance=" + msg.getDistance() +
               ", time=" + msg.getTime() + '}';
    }

}
