/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.lsst.ccs.utilities.misc.Similarity;

public class CommandArgumentMatchException
extends Exception {
    private static int MAX = 10;
    private static int MIN = 5;
    private final String command;
    private final int index;
    private final String[] names;
    private final String value;
    private final ArrayList<String> allowedValues;
    private final LinkedList<CommandArgumentMatchException> children;

    @Deprecated
    public CommandArgumentMatchException(String message) {
        throw new UnsupportedOperationException();
    }

    public CommandArgumentMatchException(String command, int index, String[] names, String value, List<String> allowedValues) {
        this.command = command;
        this.index = index;
        this.names = names;
        this.value = value;
        this.allowedValues = new ArrayList<String>(new LinkedHashSet<String>(allowedValues));
        this.children = null;
    }

    private CommandArgumentMatchException(LinkedList<CommandArgumentMatchException> children) {
        this.command = null;
        this.index = 0;
        this.names = null;
        this.value = null;
        this.allowedValues = null;
        this.children = children;
    }

    protected static void throwExceptionIfNeeded(List<CommandArgumentMatchException> exceptions) throws CommandArgumentMatchException {
        if (exceptions.size() == 1) {
            throw exceptions.get(0);
        }
        if (exceptions.size() > 1) {
            LinkedList<CommandArgumentMatchException> xx = new LinkedList<CommandArgumentMatchException>();
            exceptions.stream().flatMap(e -> e.getConstituents().stream()).forEach(e -> {
                boolean notDone = true;
                ListIterator<CommandArgumentMatchException> it = xx.listIterator();
                while (notDone && it.hasNext()) {
                    CommandArgumentMatchException x = (CommandArgumentMatchException)it.next();
                    if (x.index < e.index) {
                        it.previous();
                        it.add((CommandArgumentMatchException)e);
                        notDone = false;
                        continue;
                    }
                    if (!x.command.equals(e.command) || x.index != e.index || !Arrays.equals(x.names, e.names)) continue;
                    LinkedHashSet<String> aw = new LinkedHashSet<String>(e.allowedValues);
                    aw.removeAll(x.allowedValues);
                    x.allowedValues.addAll(aw);
                    notDone = false;
                }
                if (notDone) {
                    xx.add((CommandArgumentMatchException)e);
                }
            });
            throw xx.size() == 1 ? (CommandArgumentMatchException)xx.get(0) : new CommandArgumentMatchException(xx);
        }
    }

    @Override
    public String getMessage() {
        if (this.children == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("illegal value \"").append(this.value).append("\" for argument \"").append(this.names[this.index]);
            sb.append("\" in \"").append(this.command);
            for (String name : this.names) {
                sb.append(" ").append(name);
            }
            sb.append("\".");
            sb.append(" Allowed values: ").append(this.truncateAllowedValues(this.value, this.allowedValues)).append(".");
            return sb.toString();
        }
        return String.join((CharSequence)"\nOr ", this.children.stream().map(x -> x.getMessage()).collect(Collectors.toList()));
    }

    private String truncateAllowedValues(String value, List<String> allowedValues) {
        if (allowedValues.size() > MAX) {
            ArrayList<String> values = Similarity.head(value, allowedValues, MAX, Integer.MAX_VALUE);
            int hidden = allowedValues.size() - values.size();
            if (hidden >= MIN) {
                return ((Object)values).toString() + " and " + hidden + " more";
            }
        }
        return allowedValues.toString();
    }

    private List<CommandArgumentMatchException> getConstituents() {
        if (this.children == null) {
            return Collections.singletonList(this);
        }
        LinkedList<CommandArgumentMatchException> out = new LinkedList<CommandArgumentMatchException>();
        this.children.forEach(x -> out.addAll(x.getConstituents()));
        return out;
    }
}

