/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public abstract class PLCMsg {
    private static final Logger LOG = Logger.getLogger(PLCMsg.class.getName());
    public static int MESSAGE_SET_VERSION = 2;
    private final int version;

    public static boolean messageVersionIsBad(ByteBuffer data) {
        try {
            int ver = data.getInt(data.position());
            if (ver == MESSAGE_SET_VERSION) {
                return false;
            }
            LOG.severe(String.format("Bad version in message received from shutter. Expected %d, got %d.", MESSAGE_SET_VERSION, ver));
            return true;
        }
        catch (BufferUnderflowException exc) {
            LOG.severe("Message received from shutter is too short to contain a version number.");
            return true;
        }
    }

    protected PLCMsg() {
        this.version = MESSAGE_SET_VERSION;
    }

    protected PLCMsg(ByteBuffer data) {
        this.version = data.getInt();
    }

    public void encode(ByteBuffer data) {
        data.putInt(this.version);
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return "PLCMsg{version=" + this.version + '}';
    }
}

