/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.examples;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;

public class SpeedTest {
    public static void main(String[] args) throws IOException {
        Path tempDir = Files.createTempDirectory("rfs", new FileAttribute[0]);
        URI uri = URI.create("ccs://lsst-camera-dev.slac.stanford.edu/RestFileServer/");
        Map<String, Object> env = RestFileSystemOptions.builder().cacheLocation(tempDir).set(RestFileSystemOptions.CacheOptions.MEMORY_AND_DISK).set(RestFileSystemOptions.CacheFallback.OFFLINE).build();
        FileSystem restfs = FileSystems.newFileSystem(uri, env);
        Path pathInRestServer = restfs.getPath("dictionaries/data/FocalPlane/3702060141.ser", new String[0]);
        SpeedTest.readFile(pathInRestServer);
        SpeedTest.readFile(pathInRestServer);
        Path pathInRestServer2 = restfs.getPath("dictionaries/command/FocalPlane/846244239.ser", new String[0]);
        SpeedTest.readFile(pathInRestServer2);
        SpeedTest.readFile(pathInRestServer2);
    }

    private static void readFile(Path pathInRestServer) throws IOException {
        byte[] buffer = new byte[32768];
        int length = 0;
        long start = System.currentTimeMillis();
        try (InputStream inputStream = Files.newInputStream(pathInRestServer, new OpenOption[0]);){
            int l;
            while ((l = inputStream.read(buffer, length, buffer.length - length)) >= 0) {
                length += l;
            }
        }
        long stop = System.currentTimeMillis();
        System.out.printf("Read %d bytes in %dms\n", length, stop - start);
    }
}

